/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

abstract class TagMap<T> {
    private static final int SIZE_THRESHOLD = 64;
    private static final float RATIO_THRESHOLD = 0.75f;
    private static final Comparator<? super Map.Entry<Integer, ?>> COMPARATOR = new Comparator<Map.Entry<Integer, ?>>(){

        @Override
        public int compare(Map.Entry<Integer, ?> o1, Map.Entry<Integer, ?> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    List<T> values;

    public static <T> TagMap<T> of(Map<Integer, T> map) {
        int maxTag = TagMap.maxTag(map);
        if (TagMap.isCompact(map.size(), maxTag)) {
            return Compact.compactTagMapOf(map, maxTag);
        }
        return Sparse.sparseTagMapOf(map);
    }

    private static boolean isCompact(int size, int maxTag) {
        return maxTag <= 64 || (float)size / (float)maxTag > 0.75f;
    }

    private static <T> int maxTag(Map<Integer, T> map) {
        int maxTag = -1;
        for (int tag : map.keySet()) {
            if (tag <= maxTag) continue;
            maxTag = tag;
        }
        return maxTag;
    }

    private static <T> List<T> sortedValues(Map<Integer, T> map) {
        TreeSet entries = new TreeSet(COMPARATOR);
        entries.addAll(map.entrySet());
        ArrayList sortedValues = new ArrayList();
        for (Map.Entry<Integer, ?> entry : entries) {
            sortedValues.add(entry.getValue());
        }
        return sortedValues;
    }

    protected TagMap(Map<Integer, T> map) {
        this.values = TagMap.sortedValues(map);
    }

    public Collection<T> values() {
        return this.values;
    }

    public abstract T get(int var1);

    public abstract boolean containsKey(int var1);

    static final class Sparse<T>
    extends TagMap<T> {
        Map<Integer, T> map;

        public static <T> Sparse<T> sparseTagMapOf(Map<Integer, T> map) {
            return new Sparse<T>(map);
        }

        private Sparse(Map<Integer, T> map) {
            super(map);
            this.map = map;
        }

        @Override
        public T get(int tag) {
            return this.map.get(tag);
        }

        @Override
        public boolean containsKey(int tag) {
            return this.map.containsKey(tag);
        }
    }

    static final class Compact<T>
    extends TagMap<T> {
        Object[] elementsByTag;
        int maxTag = -1;

        public static <T> Compact<T> compactTagMapOf(Map<Integer, T> map, int maxTag) {
            return new Compact<T>(map, maxTag);
        }

        private Compact(Map<Integer, T> map, int maxTag) {
            super(map);
            this.maxTag = maxTag;
            this.elementsByTag = new Object[maxTag + 1];
            for (Map.Entry<Integer, T> entry : map.entrySet()) {
                Integer key = entry.getKey();
                if (key <= 0) {
                    throw new IllegalArgumentException("Input map key is negative or zero");
                }
                this.elementsByTag[key.intValue()] = entry.getValue();
            }
        }

        @Override
        public T get(int tag) {
            if (tag > this.maxTag) {
                return null;
            }
            return (T)this.elementsByTag[tag];
        }

        @Override
        public boolean containsKey(int tag) {
            if (tag > this.maxTag) {
                return false;
            }
            return this.elementsByTag[tag] != null;
        }
    }
}

