/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPNotificationCenter;
import com.soasta.mpulse.core.MPulseBase;
import com.soasta.mpulse.core.MPulseException;
import com.soasta.mpulse.core.beacons.MPApiCustomMetricBeacon;
import com.soasta.mpulse.core.beacons.MPApiCustomTimerBeacon;
import com.soasta.mpulse.core.collection.MPBeaconCollector;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigDimension;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.filter.MPFilterManager;
import com.soasta.mpulse.core.session.MPSession;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MPulseInternal
extends MPulseBase
implements MPNotificationCenter.MPNotificationCenterObserver {
    private static final String LOG_TAG = "MPulseInternal";
    public static final String MPULSE_BUILD_VERSION_NUMBER = "2.4.1";
    private Map<String, MPApiCustomTimerBeacon> _customTimerDictionary;
    private String _viewGroup = "";
    private String _abTest = "";
    private String[] _customDimensions = new String[10];
    private Map<String, String> _deferredCustomDimensions = new HashMap<String, String>();
    protected final Object _dimensionsLockObject = new Object();
    private static final Object _initializeLockObject = new Object();
    private static ExecutorService _threadExecutionScheduler = null;
    private static boolean _initialized = false;

    protected MPulseInternal() {
        this._customTimerDictionary = new HashMap<String, MPApiCustomTimerBeacon>();
        MPNotificationCenter.defaultCenter().addObserver(this, "BoomerangConfigRefreshed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPulseBase initializeWithAPIKey(String apiKey, URL serverUrl) {
        Object object = _initializeLockObject;
        synchronized (object) {
            if (_initialized) {
                MPLog.debug(LOG_TAG, "Already initialized");
                return mPulseInstance;
            }
            _threadExecutionScheduler = Executors.newSingleThreadScheduledExecutor();
            MPulseInternal.sharedInstance();
            try {
                MPConfig config = MPConfig.sharedInstance();
                config.setMPulseServerURL(serverUrl);
                MPBeaconCollector.sharedInstance();
                mPulseInstance.setAPIKey(apiKey);
            }
            catch (Exception ex) {
                MPLog.warn(LOG_TAG, "Unable to initialize mPulse Mobile with API Key. Exception occurred.", ex);
            }
            _initialized = true;
        }
        return mPulseInstance;
    }

    public boolean isInstanceInitialized() {
        return MPulseInternal.sharedInstance() != null;
    }

    @Override
    public String getViewGroup() {
        return this._viewGroup;
    }

    public String[] getCustomDimensions() {
        return this._customDimensions;
    }

    @Override
    public void setViewGroup(String name) {
        this._viewGroup = name;
    }

    @Override
    public void resetViewGroup() {
        this._viewGroup = "";
    }

    @Override
    public void enable() {
        try {
            MPConfig.sharedInstance().setUserEnabledBeacons(true);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to enable mPulse Mobile. Exception occurred.", ex);
        }
    }

    @Override
    public void disable() {
        try {
            MPConfig.sharedInstance().setUserEnabledBeacons(false);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to disable mPulse Mobile. Exception occurred.", ex);
        }
    }

    @Override
    public String startTimer(String timerName) {
        try {
            if (!this.isInstanceInitialized()) {
                return "";
            }
            MPApiCustomTimerBeacon beacon = new MPApiCustomTimerBeacon(timerName);
            String timerKey = timerName + "-" + UUID.randomUUID();
            MPLog.debug(LOG_TAG, "TimerKey " + timerKey);
            this._customTimerDictionary.put(timerKey, beacon);
            return timerKey;
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to start Timer. Exception occurred.", ex);
            return null;
        }
    }

    @Override
    public void cancelTimer(String timerID) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            this._customTimerDictionary.remove(timerID);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to cancel Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void stopTimer(String timerID, boolean updateDimensions) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            MPApiCustomTimerBeacon beacon = this._customTimerDictionary.get(timerID);
            if (beacon != null) {
                if (updateDimensions) {
                    MPLog.debug(LOG_TAG, "Updating dimensions for " + timerID);
                    beacon.updatePageDimensions();
                }
                beacon.endTimer();
                this._customTimerDictionary.remove(timerID);
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to stop Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void stopTimer(String timerID) {
        this.stopTimer(timerID, false);
    }

    @Override
    public void sendTimer(String timerName, long timerValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            if (timerValue > Integer.MAX_VALUE) {
                timerValue = Integer.MAX_VALUE;
            }
            new MPApiCustomTimerBeacon(timerName, (int)timerValue);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to send Timer. Exception occurred.", ex);
        }
    }

    @Override
    public void sendMetric(String metricName, Number metricValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            new MPApiCustomMetricBeacon(metricName, metricValue);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to send metric. Exception occurred.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimension(String dimensionName, String dimensionValue) {
        try {
            if (!this.isInstanceInitialized()) {
                return;
            }
            Object object = this._dimensionsLockObject;
            synchronized (object) {
                MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
                if (config != null) {
                    MPConfigDimension dimension = config.getDimension(dimensionName);
                    if (dimension != null) {
                        this._customDimensions[dimension.getIndex()] = dimensionValue != null && dimensionValue.length() > 0 ? dimensionValue : null;
                    } else {
                        MPLog.warn(LOG_TAG, "Dimension '" + dimensionName + "' not found in config, ignoring");
                    }
                } else if (dimensionValue == null || dimensionValue.length() == 0) {
                    MPLog.debug(LOG_TAG, "Deferred Dimension, '" + dimensionName + "' reset");
                    this._deferredCustomDimensions.remove(dimensionName);
                } else {
                    MPLog.debug(LOG_TAG, "Deferring set Dimension, '" + dimensionName + "' = '" + dimensionValue + "'");
                    this._deferredCustomDimensions.put(dimensionName, dimensionValue);
                }
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to set Dimension. Exception occurred.", ex);
        }
    }

    @Override
    public void resetDimension(String dimensionName) {
        this.setDimension(dimensionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllDimensions() {
        Object object = this._dimensionsLockObject;
        synchronized (object) {
            this._deferredCustomDimensions.clear();
            for (int i = 0; i < this._customDimensions.length; ++i) {
                this._customDimensions[i] = null;
            }
        }
    }

    @Override
    public String getAPIKey() {
        try {
            return MPConfig.sharedInstance().getAPIKey();
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to get API Key. Exception occurred.", ex);
            return null;
        }
    }

    @Override
    protected void setAPIKey(String apiKey) {
        try {
            if (_threadExecutionScheduler == null || _threadExecutionScheduler.isShutdown() || _threadExecutionScheduler.isTerminated()) {
                throw new MPulseException("Cannot set API key during shutdown.", new Object[0]);
            }
            MPSession.sharedInstance();
            final MPConfig config = MPConfig.sharedInstance();
            config.setAPIKey(apiKey);
            config.buildConfigRequestURL();
            _threadExecutionScheduler.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        config.refresh();
                    }
                    catch (Exception ex) {
                        MPLog.warn(MPulseInternal.LOG_TAG, "Unable to refresh Config.", ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to set API Key. Exception occurred.", ex);
        }
    }

    @Override
    public URL getServerURL() {
        try {
            return MPConfig.sharedInstance().getMPulseServerURL();
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to get Server URL. Exception occurred.", ex);
            return null;
        }
    }

    @Override
    public String getABTest() {
        return this._abTest;
    }

    @Override
    public void setABTest(String abTest) {
        this._abTest = abTest;
    }

    @Override
    public void resetABTest() {
        this._abTest = "";
    }

    @Override
    public String[] getDimensions() {
        return (String[])this._customDimensions.clone();
    }

    @Override
    public Map<String, String> getDeferredDimensions() {
        return new HashMap<String, String>(this._deferredCustomDimensions);
    }

    public static void shutdown() {
        try {
            MPulseInternal.shutdown((int)MPConfig.sharedInstance().getBeaconInterval() + 5);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Config shutdown failed.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(int maxDelay) {
        MPLog.debug(LOG_TAG, "Shutting down");
        Object object = _initializeLockObject;
        synchronized (object) {
            if (_threadExecutionScheduler != null) {
                _threadExecutionScheduler.shutdownNow();
                _threadExecutionScheduler = null;
            }
            if (MPNotificationCenter.defaultCenter() != null) {
                MPNotificationCenter.defaultCenter().clearObservers();
            }
            try {
                MPConfig config = MPConfig.sharedInstance();
                if (config != null) {
                    MPConfig.sharedInstance().setRefreshDisabled(true);
                    MPConfig.sharedInstance().shutdown();
                    MPConfig.dispose();
                }
            }
            catch (Exception ex) {
                MPLog.warn(LOG_TAG, "Config shutdown failed.", ex);
            }
            MPSession.dispose();
            if (MPBeaconCollector.sharedInstance() != null) {
                MPBeaconCollector.sharedInstance().shutdown(maxDelay);
                MPBeaconCollector.dispose();
            }
            _initialized = false;
        }
    }

    public void disableNetworkMonitoring() {
        try {
            MPConfig.sharedInstance().disableNetworkMonitoring();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured when disabling network monitoring", ex);
        }
    }

    public void enableNetworkMonitoring() {
        try {
            MPConfig.sharedInstance().enableNetworkMonitoring();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured when enabling network monitoring", ex);
        }
    }

    public void enableFilteredNetworkMonitoring() {
        try {
            MPConfig.sharedInstance().enableFilteredNetworkMonitoring();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured when enabling filtered network monitoring", ex);
        }
    }

    public MPFilterManager getFilterManager() {
        try {
            return MPConfig.sharedInstance().getFilterManager();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured when getting filtermanager instance", ex);
            return null;
        }
    }

    public void clearBlackListFilters() {
        try {
            MPConfig.sharedInstance().getFilterManager().clearUserBlackListFilters();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured clearing blacklist filters", ex);
        }
    }

    public void clearWhiteListFilters() {
        try {
            MPConfig.sharedInstance().getFilterManager().clearUserWhiteListFilters();
        }
        catch (Exception ex) {
            MPLog.debug(LOG_TAG, "An exception occured clearing whitelist filters", ex);
        }
    }

    @Override
    public void onNotification(MPNotificationCenter.MPNotification notification) {
        if (notification == null || !notification.getName().equals("BoomerangConfigRefreshed") || this._deferredCustomDimensions.isEmpty()) {
            return;
        }
        try {
            MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
            if (config != null) {
                Iterator<Map.Entry<String, String>> it = this._deferredCustomDimensions.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    String dimensionName = entry.getKey();
                    MPConfigDimension dimension = config.getDimension(dimensionName);
                    if (dimension != null) {
                        this._customDimensions[dimension.getIndex()] = entry.getValue();
                    } else {
                        MPLog.warn(LOG_TAG, "Dimension '" + dimensionName + "' not found in config, removing");
                    }
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Applying deferred custom dimensions failed.", ex);
        }
    }

    static {
        MPLog.info(LOG_TAG, "mPulse Java API build: 2.4.1");
        MPLog.info(LOG_TAG, "mPulse initialized.");
    }
}

