/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.beacons.collector.BeaconType;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.collection.MPBeaconCollector;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.config.MPConfigTimer;
import java.util.Date;

public class MPApiCustomTimerBeacon
extends MPBeacon {
    private static final String LOG_TAG = "MPApiCustomTimerBeacon";
    private int _timerIndex = -1;
    private int _timerValue;
    private boolean _hasTimerStarted;
    private boolean _hasTimerEnded;
    private String _timerName;
    private Date _startTime;

    public MPApiCustomTimerBeacon(String timerName) {
        this._timerName = timerName;
        MPConfigTimer timer = this.getTimerFromConfig(this._timerName);
        if (timer != null) {
            this._timerIndex = timer.getIndex();
        }
        this.startTimer();
    }

    public MPApiCustomTimerBeacon(int timerIndex) {
        this._timerIndex = timerIndex;
        this.startTimer();
    }

    public MPApiCustomTimerBeacon(int timerIndex, int value) {
        this.initWithTimerIndex(timerIndex, value);
    }

    public MPApiCustomTimerBeacon(String timerName, int value) {
        this._timerName = timerName;
        MPConfigTimer timer = this.getTimerFromConfig(this._timerName);
        if (timer != null) {
            this._timerIndex = timer.getIndex();
        }
        this.initWithTimerIndex(this._timerIndex, value);
    }

    private void initWithTimerIndex(int timerIndex, int value) {
        this._timerIndex = timerIndex;
        this._timerValue = value;
        this._hasTimerStarted = true;
        this._hasTimerEnded = true;
        MPBeaconCollector.sharedInstance().addBeacon(this);
    }

    private MPConfigTimer getTimerFromConfig(String timerName) {
        if (timerName.length() > 0) {
            try {
                MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
                if (config != null) {
                    return config.getTimer(timerName);
                }
            }
            catch (Exception ex) {
                MPLog.warn(LOG_TAG, "Getting timer from config failed.", ex);
            }
        }
        return null;
    }

    public void startTimer() {
        this._startTime = new Date();
        this._timerValue = 0;
        this._hasTimerStarted = true;
        this._hasTimerEnded = false;
    }

    public void endTimer() {
        if (this._startTime == null || !this._hasTimerStarted) {
            MPLog.warn(LOG_TAG, "Calling endTimer() on a timer that never started");
            return;
        }
        this._timerValue = (int)(System.currentTimeMillis() - this._startTime.getTime());
        this._hasTimerEnded = true;
        MPBeaconCollector.sharedInstance().addBeacon(this);
    }

    public boolean hasTimerStarted() {
        return this._hasTimerStarted;
    }

    public boolean hasTimerEnded() {
        return this._hasTimerEnded;
    }

    public String getTimerName() {
        return this._timerName;
    }

    public void setTimerName(String timerName) {
        this._timerName = timerName;
    }

    public int getTimerIndex() {
        return this._timerIndex;
    }

    public void setTimerIndex(int timerIndex) {
        this._timerIndex = timerIndex;
    }

    public int getTimerValue() {
        return this._timerValue;
    }

    public void setTimerValue(int timerValue) {
        this._timerValue = timerValue;
    }

    @Override
    public BeaconType getBeaconType() {
        return BeaconType.API_CUSTOM_TIMER;
    }

    @Override
    public void serialize(ClientBeaconBatch.ClientBeaconRecord.Builder record) {
        super.serialize(record);
        if (record == null) {
            return;
        }
        ClientBeaconBatch.ClientBeaconRecord.ApiCustomTimerData.Builder builder = new ClientBeaconBatch.ClientBeaconRecord.ApiCustomTimerData.Builder();
        builder.timer_index = this._timerIndex;
        builder.timer_value = this._timerValue;
        record.api_custom_timer_data = builder.build();
    }

    @Override
    public boolean validate() {
        MPConfigTimer timer;
        if (!super.validate()) {
            return false;
        }
        if (this._timerIndex == -1 && (timer = this.getTimerFromConfig(this._timerName)) != null) {
            this._timerIndex = timer.getIndex();
        }
        return this._timerIndex >= 0;
    }
}

