/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPulseInternal;
import com.soasta.mpulse.core.beacons.collector.BeaconType;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigDimension;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public abstract class MPBeacon {
    private static final String LOG_TAG = "MPBeacon";
    private Date _timestamp = new Date();
    private boolean _addedToCollector = false;
    private String _viewGroup = "";
    private String _abTest = "";
    private String[] _customDimensions = null;
    private Map<String, String> _deferredCustomDimensions = null;
    private boolean _deferrable = true;

    public MPBeacon() {
        this.updatePageDimensions();
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void resetTimestamp() {
        this._timestamp = new Date();
    }

    public boolean addedToCollector() {
        return this._addedToCollector;
    }

    public void setAddedToCollector(boolean addedToCollector) {
        this._addedToCollector = addedToCollector;
    }

    public String getViewGroup() {
        return this._viewGroup;
    }

    public void setViewGroup(String viewGroup) {
        this._viewGroup = viewGroup;
    }

    public String getAbTest() {
        return this._abTest;
    }

    public void setAbTest(String abTest) {
        this._abTest = abTest;
    }

    public void setCustomDimensions(String[] customDimensions) {
        this._customDimensions = customDimensions;
    }

    public String[] getCustomDimensions() {
        return this._customDimensions;
    }

    public boolean isDeferable() {
        return this._deferrable;
    }

    public void setDeferable(boolean deferrable) {
        this._deferrable = deferrable;
    }

    public BeaconType getBeaconType() {
        return BeaconType.BATCH;
    }

    public void serialize(ClientBeaconBatch.ClientBeaconRecord.Builder record) {
        if (record == null) {
            return;
        }
        record.timestamp = this._timestamp.getTime();
        if (this.getBeaconType().getIndex() < ClientBeaconBatch.BeaconType.values().length) {
            record.beacon_type = ClientBeaconBatch.BeaconType.values()[this.getBeaconType().getIndex()];
        }
        if (this._abTest != null && this._abTest.length() > 0) {
            record.ab_test = this._abTest;
        }
        if (this._viewGroup != null && this._viewGroup.length() > 0) {
            record.page_group = this._viewGroup;
        }
        if (this._customDimensions != null) {
            record.custom_dimensions = new ArrayList<String>();
            for (int i = 0; i < this._customDimensions.length; ++i) {
                String val = "";
                if (this._customDimensions[i] != null && this._customDimensions[i].length() > 0) {
                    val = this._customDimensions[i];
                }
                record.custom_dimensions.add(val);
            }
        }
    }

    public boolean validate() {
        if (this._deferredCustomDimensions == null || this._deferredCustomDimensions.isEmpty()) {
            return true;
        }
        try {
            MPConfigPageParams config = MPConfig.sharedInstance().getConfig();
            if (config != null) {
                Iterator<Map.Entry<String, String>> it = this._deferredCustomDimensions.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    String dimensionName = entry.getKey();
                    MPConfigDimension dimension = config.getDimension(dimensionName);
                    if (dimension != null) {
                        this._customDimensions[dimension.getIndex()] = entry.getValue();
                    } else {
                        MPLog.warn(LOG_TAG, "Dimension '" + dimensionName + "' not found in config, removing.");
                    }
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Error applying deferred custom dimensions", ex);
        }
        return this._deferredCustomDimensions.isEmpty();
    }

    public void updatePageDimensions() {
        this._viewGroup = MPulseInternal.sharedInstance().getViewGroup();
        this._abTest = MPulseInternal.sharedInstance().getABTest();
        this._customDimensions = MPulseInternal.sharedInstance().getDimensions();
        this._deferredCustomDimensions = MPulseInternal.sharedInstance().getDeferredDimensions();
    }

    public void clearPageDimensions() {
        this._viewGroup = "";
        this._abTest = "";
        this._customDimensions = null;
        this._deferredCustomDimensions = null;
    }

    public double getDuration() {
        return -1.0;
    }
}

