/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.collection;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.collection.ClientBeaconBatch;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.demographics.MPDemographicsBase;
import com.soasta.mpulse.core.session.MPSession;
import java.util.ArrayList;
import java.util.List;

public class MPBatch {
    private static final String LOG_TAG = "MPBatch";
    private List<MPBeacon> _beacons;

    public MPBatch(List<MPBeacon> beacons) {
        this._beacons = beacons;
    }

    public byte[] serialize() throws Exception {
        ClientBeaconBatch.SessionInfo protobufSession;
        ClientBeaconBatch.Builder protobufBatchBuilder = new ClientBeaconBatch.Builder();
        MPConfig config = MPConfig.sharedInstance();
        protobufBatchBuilder.boomerang_version = "2.4.1";
        protobufBatchBuilder.api_key = config.getAPIKey();
        MPDemographicsBase demographics = MPDemographicsBase.sharedInstance();
        if (demographics != null) {
            protobufBatchBuilder.manufacturer = demographics.getDeviceManufacturer();
            protobufBatchBuilder.device = demographics.getDeviceModel();
            protobufBatchBuilder.type = demographics.getDeviceType();
            protobufBatchBuilder.os = demographics.getOSVersion();
            String carrierName = demographics.getCarrierName();
            if (carrierName != null) {
                protobufBatchBuilder.isp = carrierName;
            }
            protobufBatchBuilder.connection_type = demographics.getConnectionType();
            protobufBatchBuilder.site_version = demographics.getApplicationVersion();
            float latitude = demographics.getLatitude();
            float longitude = demographics.getLongitude();
            if (latitude != 0.0f && longitude != 0.0f) {
                protobufBatchBuilder.latitude = Float.valueOf(latitude);
                protobufBatchBuilder.longitude = Float.valueOf(longitude);
            }
        }
        protobufBatchBuilder.session = protobufSession = this.serializeSession();
        protobufBatchBuilder.beacon_records = new ArrayList<ClientBeaconBatch.ClientBeaconRecord>();
        for (MPBeacon beacon : this._beacons) {
            ClientBeaconBatch.ClientBeaconRecord.Builder protobufBeaconBuilder = new ClientBeaconBatch.ClientBeaconRecord.Builder();
            beacon.serialize(protobufBeaconBuilder);
            protobufBatchBuilder.beacon_records.add(protobufBeaconBuilder.build());
        }
        ClientBeaconBatch protobufBatch = protobufBatchBuilder.build();
        return protobufBatch.toByteArray();
    }

    private ClientBeaconBatch.SessionInfo serializeSession() {
        MPSession session = MPSession.sharedInstance();
        if (session.getID() == null || !session.isStarted()) {
            MPLog.debug(LOG_TAG, "No session (ID: " + session.getID() + ", started: " + session.isStarted() + ")");
            return null;
        }
        MPLog.debug(LOG_TAG, "Serializing session (ID: " + session.getID() + ", started: " + session.isStarted() + ")");
        ClientBeaconBatch.SessionInfo.Builder protobufSessionBuilder = new ClientBeaconBatch.SessionInfo.Builder();
        protobufSessionBuilder.id = session.getID();
        if (session.getStartTime() != null) {
            protobufSessionBuilder.start_time = session.getStartTime().getTime();
        }
        if (session.getLastBeaconTime() != null) {
            protobufSessionBuilder.end_time = session.getLastBeaconTime().getTime();
        }
        protobufSessionBuilder.network_request_count_total = session.getTotalNetworkRequestCount();
        protobufSessionBuilder.network_request_duration_total = session.getTotalNetworkRequestDuration();
        return protobufSessionBuilder.build();
    }
}

