/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.collection;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPNotificationCenter;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.collection.MPBatchTransport;
import com.soasta.mpulse.core.collection.events.MPBeaconCollectorEventListener;
import com.soasta.mpulse.core.collection.events.MPBeaconCollectorEventObject;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.filter.MPFilterManager;
import com.soasta.mpulse.core.session.MPSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MPBeaconCollector
implements MPNotificationCenter.MPNotificationCenterObserver {
    private static final String LOG_TAG = "MPBeaconCollector";
    private static final int MAX_DEFERRED_BEACONS = 100;
    private static volatile MPBeaconCollector beaconCollectorInstance;
    private static final Object sharedLockObject;
    private ScheduledExecutorService _executor;
    private ArrayList<MPBeacon> _beacons;
    private ArrayList<MPBeacon> _deferredBeacons;
    private static final Object _sharedDeferredBeaconsLock;
    private boolean _disableBatchSending = false;
    private final Set<MPBeaconCollectorEventListener> _eventListeners = new HashSet<MPBeaconCollectorEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPBeaconCollector sharedInstance() {
        Object object = sharedLockObject;
        synchronized (object) {
            if (beaconCollectorInstance == null) {
                beaconCollectorInstance = new MPBeaconCollector();
            }
            return beaconCollectorInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Object object = sharedLockObject;
        synchronized (object) {
            beaconCollectorInstance = null;
        }
    }

    private MPBeaconCollector() {
        this._beacons = new ArrayList();
        this._deferredBeacons = new ArrayList();
        this._executor = Executors.newSingleThreadScheduledExecutor();
        this.enqueueSendBatchTask(5);
        MPNotificationCenter.defaultCenter().addObserver(this, "BoomerangConfigRefreshed");
    }

    public void addBeacon(final MPBeacon beacon) {
        if (this._executor.isShutdown() || this._executor.isTerminated()) {
            return;
        }
        this._executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MPBeaconCollector.this.addBeaconInternal(beacon);
                return null;
            }
        }, 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBeaconInternal(MPBeacon beacon) {
        block17: {
            try {
                if (beacon.addedToCollector()) {
                    return;
                }
                if (MPConfig.sharedInstance().beaconsEnabled() && beacon.validate() && MPConfig.sharedInstance().getFilterManager() != null && MPConfig.sharedInstance().getConfig() != null) {
                    beacon.setAddedToCollector(true);
                    MPConfigPageParams.NetworkRequestFilterOptions options = MPConfig.sharedInstance().getConfig().getNetworkRequestFilterOptions();
                    MPFilterManager manager = MPConfig.sharedInstance().getFilterManager();
                    MPLog.debug(LOG_TAG, "Checking beacon against filters in: " + MPConfig.sharedInstance().getFilterManager());
                    if (options == MPConfigPageParams.NetworkRequestFilterOptions.MATCH && (manager.hasWhiteListFilters() || manager.hasUserWhiteListFilters())) {
                        if (!manager.matchWhiteListFilter(beacon) && manager.hasUserWhiteListFilters() && !manager.matchUserWhiteListFilter(beacon)) {
                            return;
                        }
                    } else if (options == MPConfigPageParams.NetworkRequestFilterOptions.ALL && (manager.hasBlackListFilters() || manager.hasUserBlackListFilters() || manager.hasViewGroupNameFilters())) {
                        manager.matchViewGroupNameFilter(beacon);
                        if (manager.matchBlackListFilter(beacon) || manager.hasUserBlackListFilters() && manager.matchUserBlackListFilter(beacon)) {
                            return;
                        }
                    } else if (options == MPConfigPageParams.NetworkRequestFilterOptions.NONE && (manager.hasBlackListFilters() || manager.hasUserBlackListFilters()) && (manager.matchBlackListFilter(beacon) || manager.hasUserBlackListFilters() && manager.matchUserBlackListFilter(beacon))) {
                        return;
                    }
                    MPSession.sharedInstance().addBeacon(beacon);
                    this._beacons.add(beacon);
                    this.fireBeaconAddedEvent(beacon);
                    break block17;
                }
                if (beacon.isDeferable()) {
                    Object options = _sharedDeferredBeaconsLock;
                    synchronized (options) {
                        if (this._deferredBeacons.size() <= 100) {
                            this._deferredBeacons.add(beacon);
                            MPLog.debug(LOG_TAG, "Deferring beacon " + beacon.getClass().getName());
                        } else {
                            MPLog.debug(LOG_TAG, "Deferred queue full, dropping beacon " + beacon.getClass().getName());
                        }
                        break block17;
                    }
                }
                MPLog.debug(LOG_TAG, "Dropping beacon " + beacon.getClass().getName());
            }
            catch (Exception e) {
                MPLog.debug(LOG_TAG, "Failed to process incoming beacon.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeaconAddedEvent(MPBeacon beacon) {
        MPBeaconCollectorEventObject event = new MPBeaconCollectorEventObject(this, beacon);
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            MPLog.debug(LOG_TAG, "Beacon has been added, distributing to " + this._eventListeners.size() + " listener(s)... " + beacon);
            for (MPBeaconCollectorEventListener listener : this._eventListeners) {
                try {
                    listener.beaconAdded(event);
                }
                catch (Exception e) {
                    MPLog.error(LOG_TAG, "Beacon listener caused an exception", e);
                }
            }
        }
    }

    public void sendBatch() {
        if (this._disableBatchSending) {
            return;
        }
        try {
            if (this._beacons.size() == 0) {
                MPLog.debug(LOG_TAG, "No beacons to send.");
            } else {
                ArrayList<MPBeacon> beacons = this._beacons;
                this._beacons = new ArrayList();
                MPBatchTransport transport = new MPBatchTransport();
                transport.sendBatch(beacons);
            }
            this.enqueueSendBatchTask((int)MPConfig.sharedInstance().getBeaconInterval());
        }
        catch (Exception e) {
            MPLog.debug(LOG_TAG, "Failed to send batch.", e);
        }
    }

    private void enqueueSendBatchTask(int delaySeconds) {
        this._executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MPBeaconCollector.this.sendBatch();
                return null;
            }
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    public boolean isDisableBatchSending() {
        return this._disableBatchSending;
    }

    public void setDisableBatchSending(boolean disableBatchSending) {
        this._disableBatchSending = disableBatchSending;
    }

    public ArrayList<MPBeacon> getBeacons() {
        return this._beacons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(MPBeaconCollectorEventListener listener) {
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            this._eventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(MPBeaconCollectorEventListener listener) {
        Set<MPBeaconCollectorEventListener> set = this._eventListeners;
        synchronized (set) {
            this._eventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() {
        this._beacons = new ArrayList();
        Object object = _sharedDeferredBeaconsLock;
        synchronized (object) {
            this._deferredBeacons = new ArrayList();
        }
    }

    public void shutdown(int maxDelay) {
        if (maxDelay <= 0) {
            this._executor.shutdownNow();
        } else {
            this._executor.shutdown();
            try {
                this._executor.awaitTermination(maxDelay, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                MPLog.warn(LOG_TAG, "Waiting for executor termination interrupted.", e);
            }
            if (!this._executor.isTerminated()) {
                this._executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotification(MPNotificationCenter.MPNotification notification) {
        ArrayList<MPBeacon> beacons;
        Object object = _sharedDeferredBeaconsLock;
        synchronized (object) {
            if (notification == null || !notification.getName().equals("BoomerangConfigRefreshed") || this._deferredBeacons.isEmpty()) {
                return;
            }
            beacons = this._deferredBeacons;
            this._deferredBeacons = new ArrayList();
        }
        Iterator<MPBeacon> iterator = beacons.iterator();
        while (iterator.hasNext()) {
            MPBeacon beacon = iterator.next();
            beacon.setDeferable(false);
            MPLog.debug(LOG_TAG, "Re-adding beacon " + beacon.getClass().getName());
            this.addBeacon(beacon);
            iterator.remove();
        }
    }

    static {
        sharedLockObject = new Object();
        _sharedDeferredBeaconsLock = new Object();
    }
}

