/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.filter;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.filter.MPFilter;
import com.soasta.mpulse.core.filter.MPFilterEventListener;
import com.soasta.mpulse.core.filter.MPFilterMatchEvent;
import com.soasta.mpulse.core.filter.MPFilterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MPFilterManager {
    protected Map<String, MPFilter> _blackListFilters = new HashMap<String, MPFilter>();
    protected Map<String, MPFilter> _whiteListFilters = new HashMap<String, MPFilter>();
    protected Map<String, MPFilter> _userBlackListFilters = new HashMap<String, MPFilter>();
    protected Map<String, MPFilter> _userWhiteListFilters = new HashMap<String, MPFilter>();
    protected Map<String, MPFilter> _viewGroupNameFilters = new HashMap<String, MPFilter>();
    private List<MPFilterEventListener> _listeners = new ArrayList<MPFilterEventListener>();
    private static final String LOG_TAG = "MPFilterManager";

    public boolean hasBlackListFilters() {
        return !this._blackListFilters.isEmpty();
    }

    public boolean hasWhiteListFilters() {
        return !this._whiteListFilters.isEmpty();
    }

    public boolean hasUserBlackListFilters() {
        return !this._userBlackListFilters.isEmpty();
    }

    public boolean hasUserWhiteListFilters() {
        return !this._userWhiteListFilters.isEmpty();
    }

    public boolean hasViewGroupNameFilters() {
        return !this._viewGroupNameFilters.isEmpty();
    }

    public void consumePageParams(MPConfigPageParams pageParams) {
    }

    public void addBlackListFilter(String name, MPFilter filter) {
        this.addBlackListFilter(name, filter, true);
    }

    protected void addBlackListFilter(String name, MPFilter filter, boolean userGenerated) {
        if (userGenerated) {
            this._userBlackListFilters.put(name, filter);
        } else {
            this._blackListFilters.put(name, filter);
        }
    }

    public void addWhiteListFilter(String name, MPFilter filter) {
        this.addWhiteListFilter(name, filter, true);
    }

    protected void addWhiteListFilter(String name, MPFilter filter, boolean userGenerated) {
        if (userGenerated) {
            this._userWhiteListFilters.put(name, filter);
        } else {
            this._whiteListFilters.put(name, filter);
        }
    }

    public void addUserBlackListFilter(String name, MPFilter filter) {
        this._userBlackListFilters.put(name, filter);
    }

    public void addUserWhiteListFilter(String name, MPFilter filter) {
        this._userWhiteListFilters.put(name, filter);
    }

    public void addMatchEventListener(MPFilterEventListener listener) {
        this._listeners.add(listener);
    }

    public boolean matchBlackListFilter(MPBeacon beacon) {
        MPLog.debug(LOG_TAG, "Matching against Blacklist PageParams Filters...");
        return this.matchFilter(beacon, this._blackListFilters, true, "PageParams BlackList Filters");
    }

    public boolean matchWhiteListFilter(MPBeacon beacon) {
        MPLog.debug(LOG_TAG, "Matching against Whitelist PageParams Filters...");
        return this.matchFilter(beacon, this._whiteListFilters, true, "PageParams Whitelist Filters");
    }

    public boolean matchViewGroupNameFilter(MPBeacon beacon) {
        return this.matchFilter(beacon, this._viewGroupNameFilters, false, "ViewGroup Names Filters");
    }

    public void clearWhiteListFilters() {
        this._whiteListFilters = new HashMap<String, MPFilter>();
    }

    public void clearBlackListFilters() {
        this._blackListFilters = new HashMap<String, MPFilter>();
    }

    public void clearUserWhiteListFilters() {
        this._userWhiteListFilters = new HashMap<String, MPFilter>();
    }

    public void clearUserBlackListFilters() {
        this._userBlackListFilters = new HashMap<String, MPFilter>();
    }

    public boolean matchUserBlackListFilter(MPBeacon beacon) {
        MPLog.debug(LOG_TAG, "Matching against User Blacklist Filters...");
        return this.matchFilter(beacon, this._userBlackListFilters, true, "User supplied Blacklist Filters");
    }

    public boolean matchUserWhiteListFilter(MPBeacon beacon) {
        MPLog.debug(LOG_TAG, "Matching against User Whitelist Filters...");
        return this.matchFilter(beacon, this._userWhiteListFilters, true, "User supplied Whitelist Filters");
    }

    private boolean matchFilter(MPBeacon beacon, Map<String, MPFilter> filters, boolean sendEvent, String filtersName) {
        if (filtersName == null) {
            filtersName = "default Filters";
        }
        if (beacon == null) {
            return false;
        }
        String filterName = "<emtpy>";
        try {
            if (filters.isEmpty()) {
                MPLog.debug(LOG_TAG, "List of filters was empty");
                return false;
            }
            for (Map.Entry<String, MPFilter> entry : filters.entrySet()) {
                String viewGroupName;
                Object options;
                MPLog.debug(LOG_TAG, "Testing beacon(" + beacon.toString() + ") with filter: " + entry.getKey());
                MPFilter filter = entry.getValue();
                filterName = entry.getKey();
                MPFilterResult result = filter.match(beacon);
                if (result == null) continue;
                if (MPConfig.sharedInstance().getConfig() != null && (options = MPConfig.sharedInstance().getConfig().getNetworkRequestFilterOptions()) == MPConfigPageParams.NetworkRequestFilterOptions.ALL && (viewGroupName = result.getViewGroup()) != null && !viewGroupName.equals("")) {
                    MPLog.debug(LOG_TAG, "BlackList Filter (" + filterName + ") had ViewGroupName: " + viewGroupName);
                    beacon.setViewGroup(viewGroupName);
                }
                if (!result.matched()) continue;
                if (!this._listeners.isEmpty() && sendEvent) {
                    for (MPFilterEventListener listener : this._listeners) {
                        try {
                            listener.onMatched(new MPFilterMatchEvent(this, beacon));
                        }
                        catch (Exception e) {
                            MPLog.error(LOG_TAG, "Filter listener caused an exception", e);
                        }
                    }
                }
                String viewGroupName2 = result.getViewGroup();
                MPLog.debug(LOG_TAG, "Filter (" + filterName + ") had ViewGroupName: " + viewGroupName2);
                if (viewGroupName2 != null && !viewGroupName2.equals("")) {
                    beacon.setViewGroup(viewGroupName2);
                }
                MPLog.debug(LOG_TAG, "Filter(" + filterName + "): matched for beacon: " + beacon.toString());
                return true;
            }
        }
        catch (Exception exception) {
            MPLog.error(LOG_TAG, "An exception occured when iterating match for filter: " + new String(filterName) + " matching with Beacon: " + beacon.toString(), exception);
        }
        return false;
    }
}

