/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.session;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPNotificationCenter;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.config.MPConfig;
import java.util.Date;

public class MPSession
implements MPNotificationCenter.MPNotificationCenterObserver {
    private static MPSession sessionInstance;
    private static final Object sharedLockObject;
    private int _totalNetworkRequestDuration;
    private int _totalNetworkRequestCount;
    private String _id;
    private Date _startTime;
    private Date _lastBeaconTime;
    private boolean _started = false;
    private static final String LOG_TAG = "MPSession";
    public static final String SESSION_ID_REFRESHED = "SessionIDRefreshed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPSession sharedInstance() {
        Object object = sharedLockObject;
        synchronized (object) {
            if (sessionInstance == null) {
                sessionInstance = new MPSession();
            }
            return sessionInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Object object = sharedLockObject;
        synchronized (object) {
            sessionInstance = null;
        }
    }

    private MPSession() {
        MPNotificationCenter.defaultCenter().addObserver(this, "BoomerangConfigRefreshed");
    }

    private void initWithSessionID(String id) {
        this._id = id;
        this._startTime = new Date();
        this._started = true;
        MPLog.debug(id, "Session " + id + " started at " + this._startTime);
    }

    @Override
    public void onNotification(MPNotificationCenter.MPNotification notification) {
        try {
            String sessionID = notification.getUserInfo().get("SESSION_ID");
            this.receiveBoomerangConfigRefreshedNotification(sessionID);
        }
        catch (Exception ex) {
            MPLog.warn(LOG_TAG, "Unable to receive Config Refresh Notification. Exception occurred", ex);
        }
    }

    private void receiveBoomerangConfigRefreshedNotification(String sessionID) throws Exception {
        if (!this._started || this.expired()) {
            MPLog.debug(LOG_TAG, "Session is new or has expired. Resetting network request counts.");
            this.reset();
        }
        if (!this._started && sessionID != null) {
            this.initWithSessionID(sessionID);
            MPLog.info(LOG_TAG, "mPulse session has started.");
            MPNotificationCenter.defaultCenter().postNotificationName(SESSION_ID_REFRESHED, null, null);
        }
    }

    public void addBeacon(MPBeacon beacon) {
        this._lastBeaconTime = beacon.getTimestamp();
        double duration = beacon.getDuration();
        if (duration > 0.0) {
            ++this._totalNetworkRequestCount;
            this._totalNetworkRequestDuration = (int)((double)this._totalNetworkRequestDuration + duration);
            MPLog.debug(LOG_TAG, "Session request count incremented to " + this._totalNetworkRequestCount + ", total request time incremented to " + this._totalNetworkRequestDuration);
        }
    }

    private boolean expired() throws Exception {
        double sessionExpirationTime = MPConfig.sharedInstance().getSessionExpirationTime();
        if (this._lastBeaconTime == null) {
            return false;
        }
        return (double)((System.currentTimeMillis() - this._lastBeaconTime.getTime()) * 1000L) > sessionExpirationTime;
    }

    public int getTotalNetworkRequestDuration() {
        return this._totalNetworkRequestDuration;
    }

    public int getTotalNetworkRequestCount() {
        return this._totalNetworkRequestCount;
    }

    public String getID() {
        return this._id;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public Date getLastBeaconTime() {
        return this._lastBeaconTime;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void reset() {
        this._totalNetworkRequestCount = 0;
        this._totalNetworkRequestDuration = 0;
        this._started = false;
        MPLog.debug(LOG_TAG, "Session " + this._id + " reset");
    }

    static {
        sharedLockObject = new Object();
    }
}

