/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import com.soasta.thirdparty.wire.Message;
import com.soasta.thirdparty.wire.ProtoField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class BuilderAdapter<B extends Message.Builder> {
    private static final int SUFFIX_LENGTH = "$Builder".length();
    private static final Comparator<Field> ORDER_BY_FIELD_NAME = new Comparator<Field>(){

        @Override
        public int compare(Field field1, Field field2) {
            return field1.getName().compareTo(field2.getName());
        }
    };
    private final List<Field> requiredFields = new ArrayList<Field>();

    public BuilderAdapter(Class<B> builderType) {
        Class<?> messageType;
        String builderTypeName = builderType.getName();
        String messageTypeName = builderTypeName.substring(0, builderTypeName.length() - SUFFIX_LENGTH);
        try {
            messageType = Class.forName(messageTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("No message class found for builder type " + builderTypeName));
        }
        for (Field field : messageType.getDeclaredFields()) {
            ProtoField annotation = field.getAnnotation(ProtoField.class);
            if (annotation == null || annotation.label() != Message.Label.REQUIRED) continue;
            try {
                this.requiredFields.add(builderType.getField(field.getName()));
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)("No builder field found for message field " + field.getName()));
            }
        }
        Collections.sort(this.requiredFields, ORDER_BY_FIELD_NAME);
    }

    public <B extends Message.Builder> void checkRequiredFields(B builder) {
        StringBuilder sb = null;
        String plural = "";
        try {
            int size = this.requiredFields.size();
            for (int i = 0; i < size; ++i) {
                Field f = this.requiredFields.get(i);
                if (f.get(builder) != null) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    plural = "s";
                }
                sb.append("\n  ");
                sb.append(f.getName());
            }
            if (sb != null) {
                throw new IllegalStateException("Required field" + plural + " not set:" + sb);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"Unable to access required fields");
        }
    }
}

