/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import com.soasta.thirdparty.wire.ExtendableMessage;
import com.soasta.thirdparty.wire.Extension;
import java.util.LinkedHashMap;
import java.util.Map;

final class ExtensionRegistry {
    private final Map<Class<? extends ExtendableMessage>, Map<Integer, Extension<?, ?>>> extensionsByTag = new LinkedHashMap();
    private final Map<Class<? extends ExtendableMessage>, Map<String, Extension<?, ?>>> extensionsByName = new LinkedHashMap();

    ExtensionRegistry() {
    }

    public <T extends ExtendableMessage<?>, E> void add(Extension<T, E> extension) {
        Class<T> messageClass = extension.getExtendedType();
        Map<Integer, Extension<?, ?>> tagMap = this.extensionsByTag.get(messageClass);
        Map<String, Extension<?, ?>> nameMap = this.extensionsByName.get(messageClass);
        if (tagMap == null) {
            tagMap = new LinkedHashMap();
            nameMap = new LinkedHashMap();
            this.extensionsByTag.put(messageClass, tagMap);
            this.extensionsByName.put(messageClass, nameMap);
        }
        tagMap.put(extension.getTag(), extension);
        nameMap.put(extension.getName(), extension);
    }

    public <T extends ExtendableMessage<?>, E> Extension<T, E> getExtension(Class<T> messageClass, int tag) {
        Map<Integer, Extension<?, ?>> map = this.extensionsByTag.get(messageClass);
        return map == null ? null : map.get(tag);
    }

    public <T extends ExtendableMessage<?>, E> Extension<T, E> getExtension(Class<T> messageClass, String name) {
        Map<String, Extension<?, ?>> nameMap = this.extensionsByName.get(messageClass);
        return nameMap == null ? null : nameMap.get(name);
    }
}

