/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class MPLog {
    private static final String LOG_TAG = "MPulse";
    private static final Logger Log = Logger.getLogger(MPLog.class.getName());
    static boolean s_debug = false;

    private MPLog() {
        MPLog.setDebug(true);
    }

    public static void setDebug(boolean debug) {
        s_debug = debug;
    }

    public static boolean isDebug() {
        return s_debug;
    }

    public static void debug(String tag, String message) {
        if (MPLog.isDebug()) {
            Log.log(Level.INFO, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message);
        }
    }

    public static void debug(String tag, String message, Throwable throwable) {
        if (MPLog.isDebug()) {
            Log.log(Level.INFO, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message, throwable);
        }
    }

    public static void info(String tag, String message) {
        Log.log(Level.INFO, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message);
    }

    public static void error(String tag, String message) {
        Log.log(Level.SEVERE, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message);
    }

    public static void error(String tag, String message, Throwable throwable) {
        Log.log(Level.SEVERE, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message, throwable);
    }

    public static void warn(String tag, String message) {
        Log.log(Level.WARNING, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message);
    }

    public static void warn(String tag, String message, Throwable throwable) {
        Log.log(Level.WARNING, "MPulse." + tag + "[" + Thread.currentThread().getName() + "] " + message, throwable);
    }
}

