/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.MPNotificationCenter;
import com.soasta.mpulse.core.config.MPConfigPageParams;
import com.soasta.mpulse.core.filter.MPFilterManager;
import com.soasta.mpulse.core.session.MPSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class MPConfig {
    private static final String LOG_TAG = "MPConfig";
    private static final int HTTP_TIMEOUT = 10000;
    private static final int ASYNC_TASK_TIMEOUT = 30;
    private boolean _userEnabledBeacons;
    private String _apiKey;
    private URL _serverURL;
    private URL _configURL;
    private URL _beaconURL;
    private boolean _refreshDisabled;
    private List<String> _urlPatterns;
    private double _beaconInterval;
    private double _sessionExpirationTime;
    private MPConfigPageParams _config;
    private MPFilterManager _filterManager;
    private boolean _networkMonitoringOverride = false;
    private MPConfigPageParams.NetworkRequestFilterOptions _filterOption;
    private volatile boolean _beaconsEnabled = false;
    private String _currentSignature;
    private String _libraryName;
    private static MPConfig configInstance;
    private static final Object sharedLockObject;
    private static int configRefreshInterval;
    private static final int CONFIG_NOT_READY_INTERVAL = 60;
    private static final int DEFAULT_BEACON_INTERVAL = 60;
    public static final String BOOMERANG_CONFIG_REFRESHED = "BoomerangConfigRefreshed";
    public static final String CONFIG_GET_REQUEST_COMPLETE = "ConfigGetRequestComplete";
    public static final String SESSION_ID_KEY = "SESSION_ID";
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPConfig sharedInstance() throws Exception {
        Object object = sharedLockObject;
        synchronized (object) {
            if (configInstance == null) {
                configInstance = new MPConfig();
            }
            return configInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Object object = sharedLockObject;
        synchronized (object) {
            configInstance = null;
        }
    }

    private MPConfig() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        this._userEnabledBeacons = true;
        this._beaconInterval = 60.0;
        this._libraryName = "java";
        if (this._serverURL == null || this._apiKey == null || this._apiKey.length() == 0) {
            this._beaconsEnabled = false;
            return;
        }
        this._filterManager = new MPFilterManager();
        this.buildConfigRequestURL();
        this.refresh();
    }

    public void setRefreshDisabled(boolean value) {
        this._refreshDisabled = value;
    }

    public void refresh() throws Exception {
        if (this._refreshDisabled) {
            return;
        }
        this.initWithURL();
        this.enqueueRefreshTask(configRefreshInterval);
    }

    private void initWithURL() throws Exception {
        if (!this._userEnabledBeacons) {
            return;
        }
        String responseContent = null;
        ExecutorService es = Executors.newSingleThreadExecutor();
        ConfigFetcherCallable callable = new ConfigFetcherCallable(this._configURL);
        Future result = es.submit(callable);
        try {
            responseContent = (String)result.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            MPLog.warn(LOG_TAG, "Fetching config failed", e);
            responseContent = null;
        }
        es.shutdown();
        try {
            es.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            MPLog.warn(LOG_TAG, "Waiting for executor termination interrupted.", e);
        }
        if (!es.isTerminated()) {
            es.shutdownNow();
        }
        this.sendConfigRequestCompleteNotification();
        MPLog.debug(LOG_TAG, "Response received: " + responseContent);
        this.initWithResponse(responseContent);
    }

    private void markBeaconsDisabled() {
        this._beaconsEnabled = false;
        configRefreshInterval = 60;
        MPLog.debug(LOG_TAG, "Beacons disabled");
    }

    private void markBeaconsEnabled() {
        this._beaconsEnabled = true;
        configRefreshInterval = 300;
        MPLog.debug(LOG_TAG, "Beacons enabled");
    }

    public void initWithResponse(String responseContent) throws Exception {
        MPConfigPageParams tempConfigObject;
        JSONObject response;
        block12: {
            if (this.getFilterManager() == null) {
                this.setFilterManager(new MPFilterManager());
            }
            response = null;
            if (responseContent != null && responseContent.length() > 0) {
                try {
                    response = new JSONObject(responseContent);
                    if (response.get("beacon_url") == null) {
                        MPLog.error(LOG_TAG, "Invalid Config JSON received: " + responseContent);
                        this.markBeaconsDisabled();
                        return;
                    }
                    break block12;
                }
                catch (Exception e) {
                    MPLog.warn(LOG_TAG, "Error parsing Config JSON: " + responseContent, e);
                    this.markBeaconsDisabled();
                    return;
                }
            }
            MPLog.error(LOG_TAG, "Empty Config JSON received: " + responseContent);
            this.markBeaconsDisabled();
            this._config = null;
            return;
        }
        this._currentSignature = response.get("h.cr").toString();
        try {
            this._beaconInterval = response.has("beacon_interval") ? (double)response.getInt("beacon_interval") : 60.0;
        }
        catch (Exception e) {
            MPLog.warn(LOG_TAG, "Error parsing Config beacon interval: " + responseContent, e);
            this._beaconInterval = 60.0;
        }
        if (this._beaconInterval < 1.0) {
            this._beaconInterval = 60.0;
        }
        this._sessionExpirationTime = response.getJSONObject("RT").getDouble("session_exp");
        if (this._beaconURL == null) {
            String beaconURLString = response.get("beacon_url").toString();
            if (this._configURL != null) {
                int protocolIndex = this._configURL.toString().indexOf("//");
                String protocol = this._configURL.toString().substring(0, protocolIndex);
                this._beaconURL = new URL(protocol + beaconURLString.replace("\"", "") + "batch");
            }
            MPLog.debug(LOG_TAG, "Beacon URL: " + this._beaconURL);
        }
        JSONObject paramNode = response.getJSONObject("PageParams");
        this._config = tempConfigObject = new MPConfigPageParams(paramNode.toString(), this.getNetworkMonitoringOverride(), this._filterOption);
        this.getFilterManager().clearBlackListFilters();
        this.getFilterManager().clearWhiteListFilters();
        this.getFilterManager().consumePageParams(this._config);
        MPLog.debug(LOG_TAG, "Config: " + this._config);
        this._urlPatterns = new ArrayList<String>();
        JSONArray urlNode = paramNode.getJSONArray("urlPatterns");
        for (int i = 0; i < urlNode.length(); ++i) {
            String url = urlNode.getString(i);
            this._urlPatterns.add(url);
        }
        this.markBeaconsEnabled();
        String sessionID = response.get("session_id").toString();
        this.sendConfigRefreshNotification(sessionID);
        if (this._configURL != null && !this._configURL.toString().contains("&si=")) {
            this.buildConfigRequestURL();
        }
    }

    public boolean beaconsEnabled() {
        if (!this._userEnabledBeacons) {
            return false;
        }
        return this._beaconsEnabled;
    }

    public void setLibraryName(String libraryName) {
        this._libraryName = libraryName;
    }

    private void sendConfigRefreshNotification(String sessionID) {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put(SESSION_ID_KEY, sessionID);
        MPNotificationCenter.defaultCenter().postNotificationName(BOOMERANG_CONFIG_REFRESHED, null, userInfo);
    }

    private void sendConfigRequestCompleteNotification() {
        MPNotificationCenter.defaultCenter().postNotificationName(CONFIG_GET_REQUEST_COMPLETE, null, null);
    }

    public void buildConfigRequestURL() throws MalformedURLException {
        StringBuilder urlString = new StringBuilder();
        urlString.append(this._serverURL);
        String key = urlString.toString().contains("?delay=") ? "&key=" : "?key=";
        urlString.append(key);
        urlString.append(this._apiKey);
        urlString.append("&v=");
        urlString.append("2.4.2");
        urlString.append("&l=");
        urlString.append(this._libraryName);
        MPSession session = MPSession.sharedInstance();
        if (session.isStarted()) {
            urlString.append("&si=");
            urlString.append(session.getID());
        }
        this._configURL = new URL(urlString.toString());
        MPLog.debug(LOG_TAG, "Config URL: " + urlString);
    }

    private void enqueueRefreshTask(int delaySeconds) {
        if (this._executor == null || this._executor.isShutdown() || this._executor.isTerminated()) {
            return;
        }
        this._executor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MPConfig.this.refresh();
                return null;
            }
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    public MPConfigPageParams getConfig() {
        return this._config;
    }

    public URL getConfigURL() {
        return this._configURL;
    }

    public URL getBeaconURL() {
        return this._beaconURL;
    }

    public double getBeaconInterval() {
        return this._beaconInterval;
    }

    public double getSessionExpirationTime() {
        return this._sessionExpirationTime;
    }

    public boolean isUserEnabledBeacons() {
        return this._userEnabledBeacons;
    }

    public void setUserEnabledBeacons(boolean userEnabledBeacons) {
        this._userEnabledBeacons = userEnabledBeacons;
    }

    public String getAPIKey() {
        return this._apiKey;
    }

    public void setAPIKey(String apiKey) {
        this._apiKey = apiKey;
    }

    public List<String> getUrlPatterns() {
        return this._urlPatterns;
    }

    public String getCurrentSignature() {
        return this._currentSignature;
    }

    public URL getMPulseServerURL() {
        return this._serverURL;
    }

    public void setMPulseServerURL(URL serverURL) {
        this._serverURL = serverURL;
    }

    public void setFilterManager(MPFilterManager filterManager) {
        this._filterManager = filterManager;
    }

    public MPFilterManager getFilterManager() {
        return this._filterManager;
    }

    public void disableNetworkMonitoring() {
        this.getFilterManager().clearWhiteListFilters();
        this.getFilterManager().clearBlackListFilters();
        this._filterOption = MPConfigPageParams.NetworkRequestFilterOptions.NONE;
        if (this._config != null) {
            this._config.setNetworkRequestFilterOptions(this._filterOption);
            this.getFilterManager().consumePageParams(this._config);
        }
        this._networkMonitoringOverride = true;
    }

    public void enableNetworkMonitoring() {
        this.getFilterManager().clearWhiteListFilters();
        this.getFilterManager().clearBlackListFilters();
        this._filterOption = MPConfigPageParams.NetworkRequestFilterOptions.ALL;
        if (this._config != null) {
            this._config.setNetworkRequestFilterOptions(this._filterOption);
            this.getFilterManager().consumePageParams(this._config);
        }
        this._networkMonitoringOverride = true;
    }

    public void enableFilteredNetworkMonitoring() {
        this.getFilterManager().clearWhiteListFilters();
        this.getFilterManager().clearBlackListFilters();
        this._filterOption = MPConfigPageParams.NetworkRequestFilterOptions.MATCH;
        if (this._config != null) {
            this._config.setNetworkRequestFilterOptions(this._filterOption);
            this.getFilterManager().consumePageParams(this._config);
        }
        this._networkMonitoringOverride = true;
    }

    public void shutdown() {
        this._executor.shutdownNow();
    }

    public void setNetworkMonitoringOverride(boolean networkMonitoringOverride) {
        this._networkMonitoringOverride = networkMonitoringOverride;
    }

    public boolean getNetworkMonitoringOverride() {
        return this._networkMonitoringOverride;
    }

    static {
        sharedLockObject = new Object();
        configRefreshInterval = 300;
    }

    private class ConfigFetcherCallable
    implements Callable {
        private URL _configURL;

        public ConfigFetcherCallable(URL configURL) {
            this._configURL = configURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String call() {
            MPLog.debug(MPConfig.LOG_TAG, "Sending request for config: " + this._configURL);
            BasicHttpParams clientParams = new BasicHttpParams();
            clientParams.setIntParameter("http.connection.timeout", 10000);
            clientParams.setIntParameter("http.socket.timeout", 10000);
            HttpConnectionParams.setConnectionTimeout((HttpParams)clientParams, (int)10000);
            DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)clientParams);
            try {
                Header[] headers;
                HttpGet httpget = new HttpGet(this._configURL.toURI());
                HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    StatusLine statusLine;
                    MPLog.debug(MPConfig.LOG_TAG, "Config.json request failed with a 'null' entity response");
                    if (response.getStatusLine() != null) {
                        statusLine = response.getStatusLine();
                        MPLog.debug(MPConfig.LOG_TAG, "Response Code: " + String.valueOf(statusLine.getStatusCode()) + " with Message: '" + statusLine.getReasonPhrase() + "'");
                    }
                    MPConfig.sharedInstance().markBeaconsDisabled();
                    statusLine = null;
                    return statusLine;
                }
                String responseContent = EntityUtils.toString((HttpEntity)entity);
                for (Header header : headers = response.getHeaders("Cache-Control")) {
                    if (!header.getName().equals("Cache-Control")) continue;
                    String[] array = header.toString().split("max-age=");
                    configRefreshInterval = Integer.parseInt(array[1].split(",")[0]);
                }
                String string = responseContent;
                return string;
            }
            catch (Exception e) {
                MPLog.error(MPConfig.LOG_TAG, "Unable to get config.js from the server.", e);
                try {
                    MPConfig.sharedInstance().markBeaconsDisabled();
                }
                catch (Exception e2) {
                    MPLog.error(MPConfig.LOG_TAG, "Unable to disable beacons.", e2);
                }
            }
            finally {
                httpClient.getConnectionManager().closeExpiredConnections();
            }
            return null;
        }
    }
}

