/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class MPConfigDimension {
    public static final int MAX = 10;
    private String _name;
    private int _index;
    private String _type;
    private String _label;
    private String _dataType;
    private String _pageGroup;
    private boolean _hasResponderInjected;
    private boolean _beaconSent;
    private static final String LOG_TAG = "MPConfigDimension";

    public MPConfigDimension(String jsonDataString) {
        this.initWithJson(jsonDataString);
    }

    private void initWithJson(String jsonDataString) {
        if (jsonDataString == null) {
            return;
        }
        try {
            JSONObject jsonData = new JSONObject(jsonDataString);
            this._name = jsonData.has("name") ? jsonData.getString("name") : null;
            this._index = jsonData.has("index") ? jsonData.getInt("index") : 0;
            this._type = jsonData.has("type") ? jsonData.getString("type") : null;
            this._label = jsonData.has("label") ? jsonData.getString("label") : null;
            String string = this._dataType = jsonData.has("dataType") ? jsonData.getString("dataType") : null;
            if (jsonData.has("pageGroup")) {
                this._pageGroup = jsonData.getString("pageGroup");
            }
        }
        catch (JSONException e) {
            MPLog.warn(LOG_TAG, "JSONException from initWithJson", e);
        }
        this._hasResponderInjected = false;
        this._beaconSent = false;
    }

    public String toString() {
        String beaconStatus = this._beaconSent ? "YES" : "NO";
        String dimensionString = "[MPConfigDimension: beacon sent " + beaconStatus + ", pageGroup= " + this._pageGroup + ", name= " + this._name + ", index= " + this._index + ", type= " + this._type + ", label= " + this._label + ", dataType= " + this._dataType + "]";
        return dimensionString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this._name, this._type, this._label, this._dataType, this._pageGroup});
    }

    public boolean isEqualToDimension(MPConfigDimension dimension) {
        if (dimension == null) {
            return false;
        }
        boolean haveEqualIndex = this._index == dimension.getIndex();
        boolean haveEqualNames = this._name == null && dimension.getName() == null || this._name != null && this._name.equals(dimension.getName());
        boolean haveEqualTypes = this._type == null && dimension.getType() == null || this._type != null && this._type.equals(dimension.getType());
        boolean haveEqualLabels = this._label == null && dimension.getLabel() == null || this._label != null && this._label.equals(dimension.getLabel());
        boolean haveEqualDataTypes = this._dataType == null && dimension.getDataType() == null || this._dataType != null && this._dataType.equals(dimension.getDataType());
        boolean haveEqualPageGroups = this._pageGroup == null && dimension.getPageGroup() == null || this._pageGroup != null && this._pageGroup.equals(dimension.getPageGroup());
        return haveEqualIndex && haveEqualNames && haveEqualTypes && haveEqualLabels && haveEqualDataTypes && haveEqualPageGroups;
    }

    public boolean equals(Object object) {
        if (object instanceof MPConfigDimension) {
            return this.isEqualToDimension((MPConfigDimension)object);
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public String getPageGroup() {
        return this._pageGroup;
    }

    public void setBeaconSent(boolean sent) {
        this._beaconSent = sent;
    }

    public boolean getBeaconSent() {
        return this._beaconSent;
    }

    public boolean hasResponderInjected() {
        return this._hasResponderInjected;
    }

    public void setHasResponderInjected(boolean hasResponderInjected) {
        this._hasResponderInjected = hasResponderInjected;
    }

    public String getDataType() {
        return this._dataType;
    }
}

