/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import com.soasta.thirdparty.wire.Message;
import com.soasta.thirdparty.wire.ProtoField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Redactor<T extends Message> {
    private static final Redactor<?> NOOP_REDACTOR = new Redactor<Message>(null, null, null, null){

        @Override
        public Message redact(Message message) {
            return message;
        }
    };
    private static final Map<Class<? extends Message>, Redactor> redactors = new LinkedHashMap<Class<? extends Message>, Redactor>();
    private final Constructor<?> builderConstructor;
    private final List<Field> redactedFields;
    private final List<Field> messageFields;
    private final List<Redactor<?>> messageRedactors;

    Redactor(Constructor<?> builderConstructor, List<Field> redactedFields, List<Field> messageFields, List<Redactor<?>> messageRedactors) {
        this.builderConstructor = builderConstructor;
        this.redactedFields = redactedFields;
        this.messageFields = messageFields;
        this.messageRedactors = messageRedactors;
    }

    public static synchronized <T extends Message> Redactor<T> get(Class<T> messageClass) {
        Redactor existingRedactor = redactors.get(messageClass);
        if (existingRedactor != null) {
            return existingRedactor;
        }
        FutureRedactor futureRedactor = new FutureRedactor();
        redactors.put(messageClass, futureRedactor);
        try {
            Redactor<Object> redactor;
            Class<?> builderClass = Class.forName(messageClass.getName() + "$Builder");
            ArrayList<Field> redactedFields = new ArrayList<Field>();
            ArrayList<Field> messageFields = new ArrayList<Field>();
            ArrayList messageRedactors = new ArrayList();
            for (Field messageField : messageClass.getDeclaredFields()) {
                Field field;
                Redactor<?> fieldRedactor;
                if (Modifier.isStatic(messageField.getModifiers())) continue;
                ProtoField annotation = messageField.getAnnotation(ProtoField.class);
                if (annotation != null && annotation.redacted()) {
                    if (annotation.label() == Message.Label.REQUIRED) {
                        throw new IllegalArgumentException(String.format("Field %s is REQUIRED and cannot be redacted.", messageField));
                    }
                    redactedFields.add(builderClass.getDeclaredField(messageField.getName()));
                    continue;
                }
                if (!Message.class.isAssignableFrom(messageField.getType()) || (fieldRedactor = Redactor.get((field = builderClass.getDeclaredField(messageField.getName())).getType())) == NOOP_REDACTOR) continue;
                messageFields.add(field);
                messageRedactors.add(fieldRedactor);
            }
            if (redactedFields.isEmpty() && messageFields.isEmpty()) {
                redactor = NOOP_REDACTOR;
            } else {
                Constructor<?> builderConstructor = builderClass.getConstructor(messageClass);
                redactor = new Redactor<T>(builderConstructor, redactedFields, messageFields, messageRedactors);
            }
            futureRedactor.setDelegate(redactor);
            redactors.put(messageClass, redactor);
            return redactor;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public T redact(T message) {
        if (message == null) {
            return null;
        }
        try {
            Message.Builder builder = (Message.Builder)this.builderConstructor.newInstance(message);
            for (Field field : this.redactedFields) {
                field.set(builder, null);
            }
            for (int i = 0; i < this.messageFields.size(); ++i) {
                Field field;
                field = this.messageFields.get(i);
                Redactor<?> r = this.messageRedactors.get(i);
                field.set(builder, r.redact((Message)field.get(builder)));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    private static class FutureRedactor<T extends Message>
    extends Redactor<T> {
        private Redactor<T> delegate;

        public FutureRedactor() {
            super(null, null, null, null);
        }

        public void setDelegate(Redactor<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T redact(T message) {
            if (this.delegate == null) {
                throw new IllegalStateException("Delegate was not set.");
            }
            return this.delegate.redact(message);
        }
    }
}

