/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import com.soasta.thirdparty.okio.Buffer;
import com.soasta.thirdparty.okio.BufferedSource;
import com.soasta.thirdparty.okio.ByteString;
import com.soasta.thirdparty.okio.Okio;
import com.soasta.thirdparty.okio.Source;
import com.soasta.thirdparty.wire.WireType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

final class WireInput {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String ENCOUNTERED_A_NEGATIVE_SIZE = "Encountered a negative size";
    private static final String INPUT_ENDED_UNEXPECTEDLY = "The input ended unexpectedly in the middle of a field";
    private static final String PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO = "Protocol message contained an invalid tag (zero).";
    private static final String PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG = "Protocol message end-group tag did not match expected tag.";
    private static final String ENCOUNTERED_A_MALFORMED_VARINT = "WireInput encountered a malformed varint.";
    private final BufferedSource source;
    private int pos = 0;
    private int currentLimit = Integer.MAX_VALUE;
    public static final int RECURSION_LIMIT = 64;
    public int recursionDepth;
    private int lastTag;

    public static WireInput newInstance(byte[] buf) {
        return new WireInput(new Buffer().write(buf));
    }

    public static WireInput newInstance(byte[] buf, int offset, int count) {
        return new WireInput(new Buffer().write(buf, offset, count));
    }

    public static WireInput newInstance(InputStream source) {
        return new WireInput(Okio.buffer(Okio.source(source)));
    }

    public static WireInput newInstance(Source source) {
        return new WireInput(Okio.buffer(source));
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readVarint32();
        if (this.lastTag == 0) {
            throw new IOException(PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO);
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int value) throws IOException {
        if (this.lastTag != value) {
            throw new IOException(PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG);
        }
    }

    public String readString() throws IOException {
        int count = this.readVarint32();
        this.pos += count;
        return this.source.readString(count, UTF_8);
    }

    public ByteString readBytes() throws IOException {
        int count = this.readVarint32();
        return this.readBytes(count);
    }

    public ByteString readBytes(int count) throws IOException {
        this.pos += count;
        return this.source.readByteString(count);
    }

    public int readVarint32() throws IOException {
        ++this.pos;
        byte tmp = this.source.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        ++this.pos;
        tmp = this.source.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            ++this.pos;
            tmp = this.source.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                ++this.pos;
                tmp = this.source.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    ++this.pos;
                    tmp = this.source.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            ++this.pos;
                            if (this.source.readByte() < 0) continue;
                            return result;
                        }
                        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
                    }
                }
            }
        }
        return result;
    }

    public long readVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            ++this.pos;
            byte b = this.source.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
    }

    public int readFixed32() throws IOException {
        this.pos += 4;
        return this.source.readIntLe();
    }

    public long readFixed64() throws IOException {
        this.pos += 8;
        return this.source.readLongLe();
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private WireInput(BufferedSource source) {
        this.source = source;
    }

    public int pushLimit(int byteLimit) throws IOException {
        if (byteLimit < 0) {
            throw new IOException(ENCOUNTERED_A_NEGATIVE_SIZE);
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit += this.pos) > oldLimit) {
            throw new EOFException(INPUT_ENDED_UNEXPECTEDLY);
        }
        this.currentLimit = byteLimit;
        return oldLimit;
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
    }

    private boolean isAtEnd() throws IOException {
        if (this.getPosition() == (long)this.currentLimit) {
            return true;
        }
        return this.source.exhausted();
    }

    public long getPosition() {
        return this.pos;
    }

    public void skipGroup() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && !this.skipField(tag)) {
        }
    }

    private boolean skipField(int tag) throws IOException {
        switch (WireType.valueOf(tag)) {
            case VARINT: {
                this.readVarint64();
                return false;
            }
            case FIXED32: {
                this.readFixed32();
                return false;
            }
            case FIXED64: {
                this.readFixed64();
                return false;
            }
            case LENGTH_DELIMITED: {
                this.skip(this.readVarint32());
                return false;
            }
            case START_GROUP: {
                this.skipGroup();
                this.checkLastTagWas(tag & 0xFFFFFFF8 | WireType.END_GROUP.value());
                return false;
            }
            case END_GROUP: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private void skip(long count) throws IOException {
        this.pos = (int)((long)this.pos + count);
        this.source.skip(count);
    }
}

