/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons.collector;

import java.util.HashMap;
import java.util.Map;

public enum BeaconErrorSource {
    UNKNOWN(0, "unknown"),
    APP(1, "app"),
    BOOMERANG(2, "boomerang");

    private final int _index;
    private final String _name;
    private static final BeaconErrorSource[] s_values;
    private static final Map<String, BeaconErrorSource> s_names;

    private BeaconErrorSource(int index, String name) {
        this._index = index;
        this._name = name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public static BeaconErrorSource fromIndex(int num) {
        if (num >= 0 && num <= s_values.length) {
            return s_values[num];
        }
        return null;
    }

    public static BeaconErrorSource fromName(String name) {
        return s_names.get(name);
    }

    static {
        s_names = new HashMap<String, BeaconErrorSource>();
        for (BeaconErrorSource v : s_values = BeaconErrorSource.values()) {
            s_names.put(v.getName(), v);
        }
    }
}

