/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.beacons.collector;

import java.util.HashMap;
import java.util.Map;

public enum BeaconEventType {
    UNKNOWN(0, "unknown"),
    CLICK(1, "click"),
    NETWORK(2, "network"),
    LOG(3, "log");

    private final int _index;
    private final String _name;
    private static final BeaconEventType[] s_values;
    private static final Map<String, BeaconEventType> s_names;

    private BeaconEventType(int index, String name) {
        this._index = index;
        this._name = name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public static BeaconEventType fromIndex(int num) {
        if (num >= 0 && num <= s_values.length) {
            return s_values[num];
        }
        return null;
    }

    public static BeaconEventType fromName(String name) {
        return s_names.get(name);
    }

    static {
        s_names = new HashMap<String, BeaconEventType>();
        for (BeaconEventType v : s_values = BeaconEventType.values()) {
            s_names.put(v.getName(), v);
        }
    }
}

