/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.collection;

import com.soasta.mpulse.core.MPLog;
import com.soasta.mpulse.core.beacons.MPBeacon;
import com.soasta.mpulse.core.collection.MPBatch;
import com.soasta.mpulse.core.config.MPConfig;
import com.soasta.mpulse.core.session.MPSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class MPBatchTransport {
    private static final String LOG_TAG = "MPBatchTransport";
    private static final int MAX_RETRIES = 5;
    private static final int HTTP_TIMEOUT = 10000;
    private static final int RETRY_INTERVAL = 1000;

    public void sendBatch(ArrayList<MPBeacon> beacons) throws Exception {
        if (!MPSession.sharedInstance().isStarted()) {
            return;
        }
        MPLog.debug(LOG_TAG, "Serializing " + beacons.size() + " record(s)...");
        MPBatch batch = new MPBatch(beacons);
        byte[] serializedBatch = batch.serialize();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(serializedBatch.length);
        GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);
        zipStream.write(serializedBatch);
        zipStream.close();
        byteStream.close();
        byte[] compressedData = byteStream.toByteArray();
        MPLog.debug(LOG_TAG, "Serialized " + beacons.size() + " record(s) to " + serializedBatch.length + " bytes (" + compressedData.length + " bytes gzipped)");
        HttpPost request = new HttpPost(MPConfig.sharedInstance().getBeaconURL().toURI());
        request.setHeader("Content-Type", "application/x-octet-stream");
        request.setHeader("Content-Encoding", "gzip");
        request.setEntity((HttpEntity)new ByteArrayEntity(compressedData));
        if (this.sendWithRetries((HttpUriRequest)request)) {
            MPLog.debug(LOG_TAG, "Successfully sent " + beacons.size() + " record(s) to the server.");
        }
    }

    private boolean sendWithRetries(HttpUriRequest request) throws Exception {
        int attempts = 0;
        while (attempts++ < 5) {
            if (attempts > 1) {
                Thread.sleep(1000L);
            }
            try {
                BasicHttpParams params = new BasicHttpParams();
                params.setParameter("http.socket.timeout", (Object)10000);
                params.setParameter("http.connection.timeout", (Object)10000);
                DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
                HttpResponse httpResponse = client.execute(request);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 204) {
                    return true;
                }
                MPLog.debug(LOG_TAG, "Unexpected status code " + statusCode + "; re-trying.");
            }
            catch (IOException error) {
                MPLog.debug(LOG_TAG, "HTTP request failed; re-trying.", error);
            }
        }
        return false;
    }
}

