/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.mpulse.core.config;

import com.soasta.mpulse.core.MPLog;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class MPConfigMetric {
    private String _name;
    private int _index;
    private String _type;
    private String _label;
    private String _dataType;
    private boolean _hasResponderInjected;
    private boolean _beaconSent;
    private static final String LOG_TAG = "MPConfigMetric";

    public MPConfigMetric(String jsonDataString) {
        this.initWithJson(jsonDataString);
    }

    private void initWithJson(String jsonDataString) {
        if (jsonDataString == null) {
            return;
        }
        try {
            JSONObject jsonData = new JSONObject(jsonDataString);
            this._name = jsonData.has("name") ? jsonData.getString("name") : null;
            this._index = jsonData.has("index") ? jsonData.getInt("index") : 0;
            this._type = jsonData.has("type") ? jsonData.getString("type") : null;
            this._label = jsonData.has("label") ? jsonData.getString("label") : null;
            this._dataType = jsonData.has("dataType") ? jsonData.getString("dataType") : null;
        }
        catch (JSONException e) {
            MPLog.warn(LOG_TAG, "JSONException from initWithJson", e);
        }
        this._hasResponderInjected = false;
        this._beaconSent = false;
    }

    public String toString() {
        String beaconStatus = this._beaconSent ? "YES" : "NO";
        String metricString = "[MPConfigMetric: beacon sent " + beaconStatus + ", name= " + this._name + ", index= " + this._index + ", type= " + this._type + ", label= " + this._label + ", dataType= " + this._dataType + "]";
        return metricString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this._name, this._type, this._label, this._dataType});
    }

    public boolean isEqualToMetric(MPConfigMetric metric) {
        if (metric == null) {
            return false;
        }
        boolean haveEqualIndex = this._index == metric.getIndex();
        boolean haveEqualNames = this._name == null && metric.getName() == null || this._name != null && this._name.equals(metric.getName());
        boolean haveEqualTypes = this._type == null && metric.getType() == null || this._type != null && this._type.equals(metric.getType());
        boolean haveEqualLabels = this._label == null && metric.getLabel() == null || this._label != null && this._label.equals(metric.getLabel());
        boolean haveEqualDataTypes = this._dataType == null && metric.getDataType() == null || this._dataType != null && this._dataType.equals(metric.getDataType());
        return haveEqualIndex && haveEqualNames && haveEqualTypes && haveEqualLabels && haveEqualDataTypes;
    }

    public boolean equals(Object object) {
        if (object instanceof MPConfigMetric) {
            return this.isEqualToMetric((MPConfigMetric)object);
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public String getType() {
        return this._type;
    }

    public String getLabel() {
        return this._label;
    }

    public void setBeaconSent(boolean sent) {
        this._beaconSent = sent;
    }

    public boolean getBeaconSent() {
        return this._beaconSent;
    }

    public boolean hasResponderInjected() {
        return this._hasResponderInjected;
    }

    public void setHasResponderInjected(boolean hasResponderInjected) {
        this._hasResponderInjected = hasResponderInjected;
    }

    public String getDataType() {
        return this._dataType;
    }
}

