/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.okio;

import com.soasta.thirdparty.okio.Buffer;
import com.soasta.thirdparty.okio.BufferedSink;
import com.soasta.thirdparty.okio.BufferedSource;
import com.soasta.thirdparty.okio.RealBufferedSink;
import com.soasta.thirdparty.okio.RealBufferedSource;
import com.soasta.thirdparty.okio.Segment;
import com.soasta.thirdparty.okio.Sink;
import com.soasta.thirdparty.okio.Source;
import com.soasta.thirdparty.okio.Timeout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class Okio {
    private static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        return new RealBufferedSink(sink);
    }

    public static Source source(InputStream in) {
        return Okio.source(in, new Timeout());
    }

    private static Source source(final InputStream in, final Timeout timeout) {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                if (byteCount < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + byteCount);
                }
                timeout.throwIfReached();
                Segment tail = sink.writableSegment(1);
                int maxToCopy = (int)Math.min(byteCount, (long)(2048 - tail.limit));
                int bytesRead = in.read(tail.data, tail.limit, maxToCopy);
                if (bytesRead == -1) {
                    return -1L;
                }
                tail.limit += bytesRead;
                sink.size += (long)bytesRead;
                return bytesRead;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "source(" + in + ")";
            }
        };
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source(new FileInputStream(file));
    }
}

