/*
 * Decompiled with CFR 0.152.
 */
package com.soasta.thirdparty.wire;

import com.soasta.thirdparty.okio.ByteString;
import com.soasta.thirdparty.wire.EnumAdapter;
import com.soasta.thirdparty.wire.MessageAdapter;
import com.soasta.thirdparty.wire.ProtoEnum;
import com.soasta.thirdparty.wire.UnknownFieldMap;
import com.soasta.thirdparty.wire.Wire;
import com.soasta.thirdparty.wire.WireOutput;
import com.soasta.thirdparty.wire.WireType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Message {
    private static final Wire WIRE = new Wire(new Class[0]);
    private transient UnknownFieldMap unknownFields;
    private transient boolean haveCachedSerializedSize;
    private transient int cachedSerializedSize;
    protected transient int hashCode = 0;

    protected Message(Builder builder) {
        if (builder.unknownFieldMap != null) {
            this.unknownFields = new UnknownFieldMap(builder.unknownFieldMap);
        }
    }

    protected Collection<List<UnknownFieldMap.FieldValue>> unknownFields() {
        return this.unknownFields == null ? Collections.emptySet() : this.unknownFields.fieldMap.values();
    }

    protected static <T> List<T> copyOf(List<T> source) {
        return source == null ? null : new ArrayList<T>(source);
    }

    protected static <T> List<T> immutableCopyOf(List<T> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        if (source instanceof MessageAdapter.ImmutableList) {
            return source;
        }
        return Collections.unmodifiableList(new ArrayList<T>(source));
    }

    public static <E extends Enum> int intFromEnum(E value) {
        EnumAdapter<?> adapter = WIRE.enumAdapter(value.getClass());
        return adapter.toInt((ProtoEnum)((Object)value));
    }

    public static <E extends Enum> E enumFromInt(Class<E> enumClass, int value) {
        EnumAdapter<E> adapter = WIRE.enumAdapter(enumClass);
        return (E)((Enum)adapter.fromInt(value));
    }

    public byte[] toByteArray() {
        return WIRE.messageAdapter(this.getClass()).toByteArray(this);
    }

    public void writeTo(byte[] output) {
        this.writeTo(output, 0, output.length);
    }

    public void writeTo(byte[] output, int offset, int count) {
        this.write(WireOutput.newInstance(output, offset, count));
    }

    private void write(WireOutput output) {
        MessageAdapter<?> adapter = WIRE.messageAdapter(this.getClass());
        try {
            adapter.write(this, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeUnknownFieldMap(WireOutput output) throws IOException {
        if (this.unknownFields != null) {
            this.unknownFields.write(output);
        }
    }

    public int getSerializedSize() {
        if (!this.haveCachedSerializedSize) {
            MessageAdapter<?> adapter = WIRE.messageAdapter(this.getClass());
            this.cachedSerializedSize = adapter.getSerializedSize(this);
            this.haveCachedSerializedSize = true;
        }
        return this.cachedSerializedSize;
    }

    public int getUnknownFieldsSerializedSize() {
        return this.unknownFields == null ? 0 : this.unknownFields.getSerializedSize();
    }

    protected boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected boolean equals(List<?> a, List<?> b) {
        if (a != null && a.isEmpty()) {
            a = null;
        }
        if (b != null && b.isEmpty()) {
            b = null;
        }
        return a == b || a != null && a.equals(b);
    }

    protected static <T> List<T> asList(T ... a) {
        return Arrays.asList(a);
    }

    public String toString() {
        return WIRE.messageAdapter(this.getClass()).toString(this);
    }

    public static abstract class Builder<T extends Message> {
        UnknownFieldMap unknownFieldMap;

        public Builder() {
        }

        public Builder(Message message) {
            if (message != null && message.unknownFields != null) {
                this.unknownFieldMap = new UnknownFieldMap(message.unknownFields);
            }
        }

        public void addVarint(int tag, long value) {
            this.ensureUnknownFieldMap().addVarint(tag, value);
        }

        public void addFixed32(int tag, int value) {
            this.ensureUnknownFieldMap().addFixed32(tag, value);
        }

        public void addFixed64(int tag, long value) {
            this.ensureUnknownFieldMap().addFixed64(tag, value);
        }

        public void addLengthDelimited(int tag, ByteString value) {
            this.ensureUnknownFieldMap().addLengthDelimited(tag, value);
        }

        private UnknownFieldMap ensureUnknownFieldMap() {
            if (this.unknownFieldMap == null) {
                this.unknownFieldMap = new UnknownFieldMap();
            }
            return this.unknownFieldMap;
        }

        public void checkRequiredFields() {
            WIRE.builderAdapter(this.getClass()).checkRequiredFields(this);
        }

        protected static <T> List<T> checkForNulls(List<T> elements) {
            if (elements != null && !elements.isEmpty()) {
                for (T element : elements) {
                    if (element != null) continue;
                    throw new NullPointerException();
                }
            }
            return elements;
        }

        public abstract T build();
    }

    public static enum Label {
        REQUIRED(32),
        OPTIONAL(64),
        REPEATED(128),
        PACKED(256);

        public static final Comparator<Label> ORDER_BY_NAME;
        private final int value;

        private Label(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean isRepeated() {
            return this == REPEATED || this == PACKED;
        }

        public boolean isPacked() {
            return this == PACKED;
        }

        static {
            ORDER_BY_NAME = new Comparator<Label>(){

                @Override
                public int compare(Label o1, Label o2) {
                    return o1.name().compareTo(o2.name());
                }
            };
        }
    }

    public static enum Datatype {
        INT32(1),
        INT64(2),
        UINT32(3),
        UINT64(4),
        SINT32(5),
        SINT64(6),
        BOOL(7),
        ENUM(8),
        STRING(9),
        BYTES(10),
        MESSAGE(11),
        FIXED32(12),
        SFIXED32(13),
        FIXED64(14),
        SFIXED64(15),
        FLOAT(16),
        DOUBLE(17);

        public static final Comparator<Datatype> ORDER_BY_NAME;
        private static final Map<String, Datatype> TYPES_BY_NAME;
        private final int value;

        private Datatype(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public WireType wireType() {
            switch (this) {
                case INT32: 
                case INT64: 
                case UINT32: 
                case UINT64: 
                case SINT32: 
                case SINT64: 
                case BOOL: 
                case ENUM: {
                    return WireType.VARINT;
                }
                case FIXED32: 
                case SFIXED32: 
                case FLOAT: {
                    return WireType.FIXED32;
                }
                case FIXED64: 
                case SFIXED64: 
                case DOUBLE: {
                    return WireType.FIXED64;
                }
                case STRING: 
                case BYTES: 
                case MESSAGE: {
                    return WireType.LENGTH_DELIMITED;
                }
            }
            throw new AssertionError((Object)("No wiretype for datatype " + (Object)((Object)this)));
        }

        public static Datatype of(String typeString) {
            return TYPES_BY_NAME.get(typeString);
        }

        static {
            ORDER_BY_NAME = new Comparator<Datatype>(){

                @Override
                public int compare(Datatype o1, Datatype o2) {
                    return o1.name().compareTo(o2.name());
                }
            };
            TYPES_BY_NAME = new LinkedHashMap<String, Datatype>();
            TYPES_BY_NAME.put("int32", INT32);
            TYPES_BY_NAME.put("int64", INT64);
            TYPES_BY_NAME.put("uint32", UINT32);
            TYPES_BY_NAME.put("uint64", UINT64);
            TYPES_BY_NAME.put("sint32", SINT32);
            TYPES_BY_NAME.put("sint64", SINT64);
            TYPES_BY_NAME.put("bool", BOOL);
            TYPES_BY_NAME.put("enum", ENUM);
            TYPES_BY_NAME.put("string", STRING);
            TYPES_BY_NAME.put("bytes", BYTES);
            TYPES_BY_NAME.put("message", MESSAGE);
            TYPES_BY_NAME.put("fixed32", FIXED32);
            TYPES_BY_NAME.put("sfixed32", SFIXED32);
            TYPES_BY_NAME.put("fixed64", FIXED64);
            TYPES_BY_NAME.put("sfixed64", SFIXED64);
            TYPES_BY_NAME.put("float", FLOAT);
            TYPES_BY_NAME.put("double", DOUBLE);
        }
    }
}

