/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.SodaTokenFilter;
import com.socrata.exceptions.DoesNotExistException;
import com.socrata.exceptions.InvalidLocationError;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.MalformedQueryError;
import com.socrata.exceptions.MustBeLoggedInException;
import com.socrata.exceptions.QueryTimeoutException;
import com.socrata.exceptions.QueryTooComplexException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.SodaErrorResponse;
import com.socrata.utils.JacksonObjectMapperProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpLowLevel {
    private static final DateTimeFormatter RFC1123_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    protected static final int DEFAULT_MAX_RETRIES = 20;
    public static final long DEFAULT_RETRY_TIME = 1000L;
    public static final String SODA_VERSION = "$$version";
    public static final String SOCRATA_TOKEN_HEADER = "X-App-Token";
    public static final String AUTH_REQUIRED_CODE = "authentication_required";
    public static final MediaType JSON_TYPE = MediaType.APPLICATION_JSON_TYPE;
    public static final MediaType CSV_TYPE = new MediaType("text", "csv");
    private final Client client;
    private final String url;

    private static Client createClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(JacksonObjectMapperProvider.class);
        return Client.create((ClientConfig)clientConfig);
    }

    public static final HttpLowLevel instantiate(@Nonnull String url) {
        return new HttpLowLevel(HttpLowLevel.createClient(), url);
    }

    public static final HttpLowLevel instantiateBasic(@Nonnull String url, @Nonnull String userName, @Nonnull String password, @Nullable String token) {
        Client client = HttpLowLevel.createClient();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, password));
        if (token != null) {
            client.addFilter((ClientFilter)new SodaTokenFilter(token));
        }
        return new HttpLowLevel(client, url);
    }

    public HttpLowLevel(Client client, String url) {
        this.client = client;
        this.url = url;
    }

    public Client getClient() {
        return this.client;
    }

    public UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResponse follow202(URI uri, MediaType mediaType, long retryTime) throws InterruptedException, LongRunningQueryException, SodaError {
        long timeToWait = System.currentTimeMillis() - retryTime;
        if (timeToWait > 0L) {
            HttpLowLevel httpLowLevel = this;
            synchronized (httpLowLevel) {
                this.wait(timeToWait);
            }
        }
        return this.queryRaw(uri, mediaType);
    }

    public final <T> T getAsyncResults(URI uri, long waitTime, long numRetries, Class<T> cls) throws SodaError, InterruptedException {
        ClientResponse response = this.getAsyncResults(uri, JSON_TYPE, waitTime, numRetries);
        return (T)response.getEntity(cls);
    }

    public final <T> T getAsyncResults(URI uri, MediaType mediaType, long waitTime, long numRetries, GenericType<T> cls) throws SodaError, InterruptedException {
        ClientResponse response = this.getAsyncResults(uri, mediaType, waitTime, numRetries);
        return (T)response.getEntity(cls);
    }

    public final ClientResponse getAsyncResults(URI uri, MediaType mediaType, long waitTime, long numRetries) throws SodaError, InterruptedException {
        int i = 0;
        while ((long)i < numRetries) {
            try {
                ClientResponse response = this.follow202(uri, mediaType, waitTime);
                return response;
            }
            catch (LongRunningQueryException e) {
                uri = e.location;
                waitTime = Math.max(e.timeToRetry - System.currentTimeMillis(), 0L);
                ++i;
            }
        }
        throw new SodaError("Long running result did not complete within the allotted time.");
    }

    public ClientResponse deleteRaw(URI uri) throws LongRunningQueryException, SodaError {
        WebResource.Builder builder = this.client.resource(this.soda2ifyUri(uri)).accept(new String[]{"application/json"});
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        return this.processErrors(response);
    }

    public ClientResponse queryRaw(URI uri, MediaType mediaType) throws LongRunningQueryException, SodaError {
        WebResource.Builder builder = this.client.resource(this.soda2ifyUri(uri)).accept(new MediaType[]{mediaType});
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        return this.processErrors(response);
    }

    public ClientResponse postRaw(URI uri, MediaType mediaType, Object object) throws LongRunningQueryException, SodaError {
        WebResource.Builder builder = (WebResource.Builder)this.client.resource(this.soda2ifyUri(uri)).accept(new String[]{"application/json"}).type(mediaType);
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, object);
        return this.processErrors(response);
    }

    public ClientResponse postFileRaw(URI uri, MediaType mediaType, File file) throws LongRunningQueryException, SodaError {
        WebResource.Builder builder = (WebResource.Builder)this.client.resource(this.soda2ifyUri(uri)).accept(new String[]{"application/json"}).type(MediaType.MULTIPART_FORM_DATA_TYPE);
        FormDataMultiPart form = new FormDataMultiPart();
        form.bodyPart((BodyPart)new FileDataBodyPart(file.getName(), file, mediaType));
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)form);
        return this.processErrors(response);
    }

    public <T> ClientResponse putRaw(URI uri, MediaType mediaType, Object object) throws LongRunningQueryException, SodaError {
        WebResource.Builder builder = (WebResource.Builder)this.client.resource(this.soda2ifyUri(uri)).accept(new String[]{"application/json"}).type(mediaType);
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, object);
        return this.processErrors(response);
    }

    private URI soda2ifyUri(URI uri) {
        return UriBuilder.fromUri((URI)uri).queryParam(SODA_VERSION, new Object[]{"2.0"}).build(new Object[0]);
    }

    private ClientResponse processErrors(ClientResponse response) throws SodaError, LongRunningQueryException {
        if (response.getStatus() == 200) {
            return response;
        }
        if (response.getStatus() == 202) {
            String location = (String)response.getHeaders().getFirst((Object)"Location");
            String retryAfter = (String)response.getHeaders().getFirst((Object)"Retry-After");
            try {
                throw new LongRunningQueryException(new URI(location), this.parseRetryAfter(retryAfter));
            }
            catch (URISyntaxException e) {
                throw new InvalidLocationError(location);
            }
        }
        SodaErrorResponse sodaErrorResponse = (SodaErrorResponse)response.getEntity(SodaErrorResponse.class);
        if (response.getStatus() == 400) {
            throw new MalformedQueryError(sodaErrorResponse);
        }
        if (response.getStatus() == 403) {
            if (AUTH_REQUIRED_CODE.equals(sodaErrorResponse.code)) {
                throw new MustBeLoggedInException(sodaErrorResponse);
            }
            throw new QueryTooComplexException(sodaErrorResponse);
        }
        if (response.getStatus() == 404) {
            throw new DoesNotExistException(sodaErrorResponse);
        }
        if (response.getStatus() == 408) {
            throw new QueryTimeoutException(sodaErrorResponse);
        }
        throw new SodaError(sodaErrorResponse);
    }

    private long parseRetryAfter(String retryAfter) {
        if (StringUtils.isNumeric((CharSequence)retryAfter)) {
            return System.currentTimeMillis() + (long)Integer.parseInt(retryAfter) * 1000L;
        }
        try {
            DateTime date = RFC1123_DATE_FORMAT.parseDateTime(retryAfter);
            if (date == null) {
                return 1000L;
            }
            return date.getMillis();
        }
        catch (Exception e) {
            return 1000L;
        }
    }
}

