/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.Meta;
import com.socrata.model.UpsertResult;
import com.socrata.model.soql.SoqlQuery;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Soda2Base {
    public static final String SODA_BASE_PATH = "resource";
    public static final String SODA_QUERY = "$query";
    private final HttpLowLevel httpLowLevel;

    public Soda2Base(HttpLowLevel httpLowLevel) {
        this.httpLowLevel = httpLowLevel;
    }

    public ClientResponse query(String resourceId, MediaType mediaType, SoqlQuery query) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.queryRaw(query.toSodaUri(builder).build(new Object[0]), mediaType);
    }

    public ClientResponse query(String resourceId, MediaType mediaType, String query) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).queryParam(SODA_QUERY, new Object[]{query});
        return this.httpLowLevel.queryRaw(builder.build(new Object[0]), mediaType);
    }

    public ClientResponse getById(String resourceId, MediaType mediaType, String uniqueId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId);
        return this.httpLowLevel.queryRaw(builder.build(new Object[0]), mediaType);
    }

    public void doTruncate(String resourceId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        this.httpLowLevel.deleteRaw(builder.build(new Object[0]));
    }

    public void doDelete(String resourceId, String uniqueId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId);
        this.httpLowLevel.deleteRaw(builder.build(new Object[0]));
    }

    public <T> Meta doAdd(String resourceId, T object) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        ClientResponse response = this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, object);
        return (Meta)response.getEntity(Meta.class);
    }

    public <T> T doAdd(String resourceId, T object, Class<T> retType) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        ClientResponse response = this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, object);
        return (T)response.getEntity(retType);
    }

    public <T> UpsertResult doAddObjects(String resourceId, Collection<T> objects) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        ClientResponse response = this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, objects);
        return (UpsertResult)response.getEntity(UpsertResult.class);
    }

    public UpsertResult doAddStream(String resourceId, MediaType mediaType, InputStream stream) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        ClientResponse response = this.httpLowLevel.postRaw(builder.build(new Object[0]), mediaType, stream);
        return (UpsertResult)response.getEntity(UpsertResult.class);
    }

    public Meta doUpdate(String resourceId, Object uniqueId, Object object) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId.toString());
        ClientResponse response = this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, object);
        return (Meta)response.getEntity(Meta.class);
    }

    public final HttpLowLevel getHttpLowLevel() {
        return this.httpLowLevel;
    }
}

