/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.api.Soda2Base;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.soql.SoqlQuery;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Soda2Consumer
extends Soda2Base {
    public static final Soda2Consumer newConsumer(String url) {
        return new Soda2Consumer(HttpLowLevel.instantiate(url));
    }

    public static final Soda2Consumer newConsumer(String url, String userName, String password, String token) {
        return new Soda2Consumer(HttpLowLevel.instantiateBasic(url, userName, password, token));
    }

    public Soda2Consumer(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
    }

    public <T> T getById(String resourceId, String id, Class<T> cls) throws SodaError, InterruptedException {
        try {
            ClientResponse response = this.getById(resourceId, HttpLowLevel.JSON_TYPE, id);
            return (T)response.getEntity(new GenericType(cls));
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, new GenericType(cls));
        }
    }

    public <T> List<T> query(String resourceId, SoqlQuery query, GenericType<List<T>> genericType) throws SodaError, InterruptedException {
        try {
            ClientResponse response = this.query(resourceId, HttpLowLevel.JSON_TYPE, query);
            return (List)response.getEntity(genericType);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, genericType);
        }
    }

    public <T> List<T> query(String resourceId, String query, GenericType<List<T>> genericType) throws SodaError, InterruptedException {
        try {
            ClientResponse response = this.query(resourceId, HttpLowLevel.JSON_TYPE, query);
            return (List)response.getEntity(genericType);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, genericType);
        }
    }
}

