/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.api.Soda2Consumer;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.Meta;
import com.socrata.model.UpsertResult;
import com.sun.jersey.api.client.GenericType;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Soda2Producer
extends Soda2Consumer {
    public static final Soda2Producer newProducer(String url, String userName, String password, String token) {
        return new Soda2Producer(HttpLowLevel.instantiateBasic(url, userName, password, token));
    }

    public Soda2Producer(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
    }

    public void truncate(String resourceId) throws SodaError, InterruptedException {
        try {
            this.doTruncate(resourceId);
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, new GenericType(String.class));
        }
    }

    public void delete(String resourceId, String id) throws SodaError, InterruptedException {
        try {
            this.doDelete(resourceId, id);
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, new GenericType(String.class));
        }
    }

    public <T> Meta addObject(String resourceId, T object) throws SodaError, InterruptedException {
        try {
            return this.doAdd(resourceId, object);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, Meta.class);
        }
    }

    public <T> T addObject(String resourceId, T object, Class<T> retType) throws SodaError, InterruptedException {
        try {
            return this.doAdd(resourceId, object, retType);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, retType);
        }
    }

    public UpsertResult upsert(String resourceId, List objects) throws SodaError, InterruptedException {
        try {
            return this.doAddObjects(resourceId, objects);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, UpsertResult.class);
        }
    }

    public UpsertResult upsertStream(String resourceId, MediaType mediaType, InputStream stream) throws SodaError, InterruptedException {
        try {
            return this.doAddStream(resourceId, mediaType, stream);
        }
        catch (LongRunningQueryException e) {
            return (UpsertResult)this.getHttpLowLevel().getAsyncResults(e.location, mediaType, e.timeToRetry, 20L, new GenericType(InputStream.class));
        }
    }

    public <T> Meta update(String resourceId, Object id, T object) throws SodaError, InterruptedException {
        try {
            return this.doUpdate(resourceId, id, object);
        }
        catch (LongRunningQueryException e) {
            return (Meta)this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, 20L, new GenericType(Meta.class));
        }
    }
}

