/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.builders.BlueprintBuilder;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.GeocodingResults;
import com.socrata.model.importer.Blueprint;
import com.socrata.model.importer.BlueprintColumn;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.ScanResults;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.map.ObjectMapper;

public class SodaImporter {
    public static final String IMPORTER_BASE_PATH = "api";
    public static final String SCAN_BASE_PATH = "imports2";
    public static final String VIEWS_BASE_PATH = "views";
    public static final String GEO_BASE_PATH = "geocoding";
    private final HttpLowLevel httpLowLevel;
    private final URI viewUri;
    private final URI importUri;
    private final URI geocodingUri;
    private final ObjectMapper mapper = new ObjectMapper();
    static final long ticketCheck = 10000L;

    public SodaImporter(HttpLowLevel httpLowLevel) {
        this.httpLowLevel = httpLowLevel;
        this.viewUri = httpLowLevel.uriBuilder().path(IMPORTER_BASE_PATH).path(VIEWS_BASE_PATH).build(new Object[0]);
        this.importUri = httpLowLevel.uriBuilder().path(IMPORTER_BASE_PATH).path(SCAN_BASE_PATH).build(new Object[0]);
        this.geocodingUri = httpLowLevel.uriBuilder().path(IMPORTER_BASE_PATH).path(GEO_BASE_PATH).build(new Object[0]);
    }

    public HttpLowLevel getHttpLowLevel() {
        return this.httpLowLevel;
    }

    Dataset createView(Dataset view) throws SodaError, InterruptedException {
        try {
            ClientResponse response = this.httpLowLevel.postRaw(this.viewUri, HttpLowLevel.JSON_TYPE, view);
            return (Dataset)response.getEntity(Dataset.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, Dataset.class);
        }
    }

    Dataset loadView(String id) throws LongRunningQueryException, SodaError {
        URI uri = UriBuilder.fromUri((URI)this.viewUri).path(id).build(new Object[0]);
        ClientResponse response = this.httpLowLevel.queryRaw(uri, HttpLowLevel.JSON_TYPE);
        return (Dataset)response.getEntity(Dataset.class);
    }

    Dataset updateView(Dataset view) throws SodaError, InterruptedException {
        try {
            URI uri = UriBuilder.fromUri((URI)this.viewUri).path(view.getId()).build(new Object[0]);
            ClientResponse response = this.httpLowLevel.putRaw(uri, HttpLowLevel.JSON_TYPE, view);
            return (Dataset)response.getEntity(Dataset.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, Dataset.class);
        }
    }

    void deleteView(String id) throws SodaError, InterruptedException {
        try {
            URI uri = UriBuilder.fromUri((URI)this.viewUri).path(id).build(new Object[0]);
            this.httpLowLevel.deleteRaw(uri);
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, Dataset.class);
        }
    }

    Dataset createViewFromCsv(String name, String description, File file) throws InterruptedException, SodaError, IOException {
        return this.importScanResults(name, description, file, this.scan(file));
    }

    public ScanResults scan(File file) throws SodaError, InterruptedException {
        try {
            URI scanUri = UriBuilder.fromUri((URI)this.importUri).queryParam("method", new Object[]{"scan"}).build(new Object[0]);
            ClientResponse response = this.httpLowLevel.postFileRaw(scanUri, HttpLowLevel.CSV_TYPE, file);
            return (ScanResults)response.getEntity(ScanResults.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, ScanResults.class);
        }
    }

    public Dataset publish(String datasetId) throws SodaError, InterruptedException {
        this.waitForPendingGeocoding(datasetId);
        URI publicationUri = UriBuilder.fromUri((URI)this.viewUri).path(datasetId).path("publication").build(new Object[0]);
        try {
            ClientResponse response = this.httpLowLevel.postRaw(publicationUri, HttpLowLevel.JSON_TYPE, "viewId=" + datasetId);
            return (Dataset)response.getEntity(Dataset.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, Dataset.class);
        }
    }

    public void waitForPendingGeocoding(String datasetId) throws InterruptedException, SodaError {
        GeocodingResults geocodingResults = this.findPendingGeocodingResults(datasetId);
        while (geocodingResults.getTotal() > 0L) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            geocodingResults = this.findPendingGeocodingResults(datasetId);
        }
    }

    public GeocodingResults findPendingGeocodingResults(String datasetId) throws SodaError, InterruptedException {
        try {
            URI uri = UriBuilder.fromUri((URI)this.geocodingUri).path(datasetId).queryParam("method", new Object[]{"pending"}).build(new Object[0]);
            ClientResponse response = this.httpLowLevel.queryRaw(uri, HttpLowLevel.JSON_TYPE);
            return (GeocodingResults)response.getEntity(GeocodingResults.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, 20L, GeocodingResults.class);
        }
    }

    public Dataset importScanResults(String name, String description, File file, ScanResults scanResults) throws SodaError, InterruptedException, IOException {
        Blueprint blueprint = new BlueprintBuilder(scanResults).setSkip(1).setName(name).setDescription(description).build();
        return this.importScanResults(blueprint, null, file, scanResults);
    }

    public Dataset importScanResults(Blueprint blueprint, String[] translation, File file, ScanResults scanResults) throws SodaError, InterruptedException, IOException {
        try {
            String translationString = this.mapper.writeValueAsString((Object)(translation != null ? translation : this.generateTranslation(blueprint)));
            String blueprintString = this.mapper.writeValueAsString((Object)blueprint);
            String postData = "translation=" + URLEncoder.encode(translationString, "UTF-8") + "&fileId=" + scanResults.getFileId() + "&name=" + file.getName() + "&blueprint=" + URLEncoder.encode(blueprintString, "UTF-8");
            ClientResponse response = this.httpLowLevel.postRaw(this.importUri, MediaType.APPLICATION_FORM_URLENCODED_TYPE, postData);
            return (Dataset)response.getEntity(Dataset.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, Integer.MAX_VALUE, Dataset.class);
        }
    }

    public String[] generateTranslation(Blueprint blueprint) {
        String[] retVal = new String[blueprint.getColumns().size()];
        int i = 0;
        for (BlueprintColumn column : blueprint.getColumns()) {
            retVal[i++] = column.getName();
        }
        return retVal;
    }
}

