/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.utils;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.util.StdDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Immutable
public class JacksonObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    protected static final SimpleDateFormat SOCRATA_WRITING_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected static final SimpleDateFormat SOCRATA_FLOATING_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final SimpleDateFormat SOCRATA_FLOATING_FORMAT_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    protected static final DateFormat[] SPECIAL_DATE_LIST = new DateFormat[]{SOCRATA_FLOATING_FORMAT_MILLIS, SOCRATA_FLOATING_FORMAT};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return OBJECT_MAPPER;
    }

    static {
        OBJECT_MAPPER.setDateFormat((DateFormat)((Object)new SocrataDateFormat()));
    }

    protected static class SocrataDateFormat
    extends StdDateFormat {
        final SimpleDateFormat SOCRATA_WRITE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        final SimpleDateFormat SOCRATA_FLOATING_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        final SimpleDateFormat SOCRATA_FLOATING_FORMAT_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        final DateFormat[] SPECIAL_DATE_LIST = new DateFormat[]{this.SOCRATA_FLOATING_FORMAT_MILLIS, this.SOCRATA_FLOATING_FORMAT};

        public SocrataDateFormat() {
            TimeZone localTimezone = TimeZone.getDefault();
            this.SOCRATA_WRITE_FORMAT.setTimeZone(localTimezone);
        }

        protected Date parseAsISO8601(String dateStr, ParsePosition pos) {
            Date retVal = this.parseAsFloatingISO8601(dateStr, pos);
            if (retVal != null) {
                return retVal;
            }
            return super.parseAsISO8601(dateStr, pos);
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return SOCRATA_WRITING_FORMAT.format(date, toAppendTo, fieldPosition);
        }

        private Date parseAsFloatingISO8601(String dateString, ParsePosition pos) {
            int len = dateString.length();
            char c = dateString.charAt(len - 1);
            if (c != 'z' && c != 'Z') {
                for (DateFormat format : this.SPECIAL_DATE_LIST) {
                    ParsePosition testPos = new ParsePosition(pos.getIndex());
                    DateFormat safeFormat = (DateFormat)format.clone();
                    Date retVal = safeFormat.parse(dateString, testPos);
                    if (retVal == null || testPos.getIndex() != len) continue;
                    pos.setIndex(testPos.getIndex());
                    return retVal;
                }
            }
            return null;
        }

        public StdDateFormat clone() {
            return new SocrataDateFormat();
        }
    }
}

