/*
 * Decompiled with CFR 0.152.
 */
package com.sparsity.dex.gdb;

import com.sparsity.dex.gdb.DataType;
import com.sparsity.dex.gdb.TextStream;
import com.sparsity.dexjavawrapJNI;
import java.util.Calendar;
import java.util.Date;

public class Value {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    public static final int MaxLengthString = Value.getMaxLengthString();

    public Value(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Value value) {
        return value == null ? 0L : value.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                dexjavawrapJNI.delete_dex_gdb_Value(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public String toString() {
        if (this.isNull()) {
            return "#NULL#";
        }
        String string = null;
        switch (this.getDataType()) {
            case Boolean: {
                string = Boolean.valueOf(this.getBoolean()).toString();
                break;
            }
            case Integer: {
                string = Integer.valueOf(this.getInteger()).toString();
                break;
            }
            case Long: {
                string = Long.valueOf(this.getLong()).toString();
                break;
            }
            case Double: {
                string = Double.valueOf(this.getDouble()).toString();
                break;
            }
            case Timestamp: {
                string = this.getTimestampAsDate().toString();
                break;
            }
            case String: {
                string = this.getString();
                break;
            }
            case Text: {
                throw new UnsupportedOperationException();
            }
            case OID: {
                string = Long.valueOf(this.getOID()).toString();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Value) {
            Value value = (Value)object;
            bl = this.equals(value);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        switch (this.getDataType()) {
            case Boolean: {
                n = Boolean.valueOf(this.getBoolean()).hashCode();
                break;
            }
            case Integer: {
                n = Integer.valueOf(this.getInteger()).hashCode();
                break;
            }
            case Long: {
                n = Long.valueOf(this.getLong()).hashCode();
                break;
            }
            case Double: {
                n = Double.valueOf(this.getDouble()).hashCode();
                break;
            }
            case Timestamp: {
                n = Long.valueOf(this.getTimestamp()).hashCode();
                break;
            }
            case String: {
                n = this.getString().hashCode();
                break;
            }
            case Text: {
                throw new UnsupportedOperationException();
            }
            case OID: {
                n = Long.valueOf(this.getOID()).hashCode();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n;
    }

    public int compareTo(Value value) {
        return this.compare(value);
    }

    public int compareTo(Object object) {
        if (object instanceof Value) {
            return this.compare((Value)object);
        }
        throw new ClassCastException("Value can just be compared to other Value instances");
    }

    public Value setNull() {
        this.setNullVoid();
        return this;
    }

    public Value setBoolean(boolean bl) {
        this.setBooleanVoid(bl);
        return this;
    }

    public Value setInteger(int n) {
        this.setIntegerVoid(n);
        return this;
    }

    public Value setLong(long l) {
        this.setLongVoid(l);
        return this;
    }

    public Value setDouble(double d) {
        this.setDoubleVoid(d);
        return this;
    }

    public Value setTimestamp(long l) {
        this.setTimestampVoid(l);
        return this;
    }

    public Value setTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setTimestampVoid(n, n2, n3, n4, n5, n6, n7);
        return this;
    }

    public Value setString(String string) {
        this.setStringVoid(string);
        return this;
    }

    public Value setOID(long l) {
        this.setOIDVoid(l);
        return this;
    }

    public Value setText(TextStream textStream) {
        this.setTextVoid(textStream);
        return this;
    }

    public Value set(Value value) {
        this.setVoid(value);
        return this;
    }

    public Value setTimestamp(Calendar calendar) {
        this.setTimestampVoid(calendar.getTimeInMillis());
        return this;
    }

    public Value setTimestamp(Date date) {
        this.setTimestampVoid(date.getTime());
        return this;
    }

    public Calendar getTimestampAsCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getTimestamp());
        return calendar;
    }

    public Date getTimestampAsDate() {
        return new Date(this.getTimestamp());
    }

    public Value() {
        this(dexjavawrapJNI.new_dex_gdb_Value__SWIG_0(), true);
    }

    public Value(Value value) {
        this(dexjavawrapJNI.new_dex_gdb_Value__SWIG_1(Value.getCPtr(value), value), true);
    }

    public boolean isNull() {
        return dexjavawrapJNI.dex_gdb_Value_isNull(this.swigCPtr, this);
    }

    public void setNullVoid() {
        dexjavawrapJNI.dex_gdb_Value_setNullVoid(this.swigCPtr, this);
    }

    public DataType getDataType() {
        return DataType.swigToEnum(dexjavawrapJNI.dex_gdb_Value_getDataType(this.swigCPtr, this));
    }

    public boolean getBoolean() {
        return dexjavawrapJNI.dex_gdb_Value_getBoolean(this.swigCPtr, this);
    }

    public int getInteger() {
        return dexjavawrapJNI.dex_gdb_Value_getInteger(this.swigCPtr, this);
    }

    public long getLong() {
        return dexjavawrapJNI.dex_gdb_Value_getLong(this.swigCPtr, this);
    }

    public double getDouble() {
        return dexjavawrapJNI.dex_gdb_Value_getDouble(this.swigCPtr, this);
    }

    public long getTimestamp() {
        return dexjavawrapJNI.dex_gdb_Value_getTimestamp(this.swigCPtr, this);
    }

    public String getString() {
        return dexjavawrapJNI.dex_gdb_Value_getString(this.swigCPtr, this);
    }

    public long getOID() {
        return dexjavawrapJNI.dex_gdb_Value_getOID(this.swigCPtr, this);
    }

    public TextStream getText() {
        long l = dexjavawrapJNI.dex_gdb_Value_getText(this.swigCPtr, this);
        return l == 0L ? null : new TextStream(l, true);
    }

    public void setBooleanVoid(boolean bl) {
        dexjavawrapJNI.dex_gdb_Value_setBooleanVoid(this.swigCPtr, this, bl);
    }

    public void setIntegerVoid(int n) {
        dexjavawrapJNI.dex_gdb_Value_setIntegerVoid(this.swigCPtr, this, n);
    }

    public void setLongVoid(long l) {
        dexjavawrapJNI.dex_gdb_Value_setLongVoid(this.swigCPtr, this, l);
    }

    public void setDoubleVoid(double d) {
        dexjavawrapJNI.dex_gdb_Value_setDoubleVoid(this.swigCPtr, this, d);
    }

    public void setTimestampVoid(long l) {
        dexjavawrapJNI.dex_gdb_Value_setTimestampVoid__SWIG_0(this.swigCPtr, this, l);
    }

    public void setTimestampVoid(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        dexjavawrapJNI.dex_gdb_Value_setTimestampVoid__SWIG_1(this.swigCPtr, this, n, n2, n3, n4, n5, n6, n7);
    }

    public void setStringVoid(String string) {
        dexjavawrapJNI.dex_gdb_Value_setStringVoid(this.swigCPtr, this, string);
    }

    public void setOIDVoid(long l) {
        dexjavawrapJNI.dex_gdb_Value_setOIDVoid(this.swigCPtr, this, l);
    }

    public void setTextVoid(TextStream textStream) {
        dexjavawrapJNI.dex_gdb_Value_setTextVoid(this.swigCPtr, this, TextStream.getCPtr(textStream), textStream);
    }

    public void setVoid(Value value) {
        dexjavawrapJNI.dex_gdb_Value_setVoid(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public int compare(Value value) {
        return dexjavawrapJNI.dex_gdb_Value_compare(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public boolean equals(Value value) {
        return dexjavawrapJNI.dex_gdb_Value_equals(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public static int getMaxLengthString() {
        return dexjavawrapJNI.dex_gdb_Value_MaxLengthString_get();
    }
}

