/*
 * Decompiled with CFR 0.152.
 */
package com.sparsity.dex.gdb;

import com.sparsity.dex.gdb.ObjectsIterator;
import com.sparsity.dexjavawrapJNI;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Objects
implements Closeable,
Iterable<Long>,
Set<Long> {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    public static final long InvalidOID = Objects.getInvalidOID();

    public Objects(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Objects objects) {
        return objects == null ? 0L : objects.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                dexjavawrapJNI.delete_dex_gdb_Objects(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public boolean isClosed() {
        return 0L == this.swigCPtr;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (collection instanceof Objects) {
            long l = this.count();
            long l2 = this.difference((Objects)collection);
            return l2 != l;
        }
        boolean bl = false;
        ObjectsIterator objectsIterator = this.iterator();
        while (objectsIterator.hasNext()) {
            long l = objectsIterator.next();
            if (!collection.contains(l)) continue;
            bl &= this.remove(l);
        }
        objectsIterator.close();
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (collection instanceof Objects) {
            long l = this.count();
            long l2 = this.intersection((Objects)collection);
            return l2 != l;
        }
        boolean bl = false;
        ObjectsIterator objectsIterator = this.iterator();
        while (objectsIterator.hasNext()) {
            long l = objectsIterator.next();
            if (collection.contains(l)) continue;
            bl &= this.remove(l);
        }
        objectsIterator.close();
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        if (collection == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (collection instanceof Objects) {
            long l = this.count();
            long l2 = this.union((Objects)collection);
            return l2 != l;
        }
        boolean bl = false;
        for (Long l : collection) {
            if (l == null) {
                throw new NullPointerException("This collection does not support null elements.");
            }
            bl |= this.add((long)l);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl;
        if (collection == null) {
            throw new NullPointerException("The specified collection is null.");
        }
        if (collection instanceof Objects) {
            Objects objects = Objects.combineIntersection(this, (Objects)collection);
            bl = objects.count() == ((Objects)collection).count();
            objects.close();
        } else {
            Object obj;
            Iterator<?> iterator = collection.iterator();
            for (bl = true; iterator.hasNext() && bl; bl &= this.exists((Long)obj)) {
                obj = iterator.next();
                if (obj == null) {
                    throw new NullPointerException("The specified collection contains one or more null elements and this set does not support null elements");
                }
                if (obj instanceof Long) {
                    continue;
                }
                throw new ClassCastException("The types of one or more elements in the specified collection are incompatible with this set.");
            }
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (object instanceof Long) {
            return this.remove((Long)object);
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public boolean add(Long l) {
        if (l == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        return this.add((long)l);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray == null) {
            throw new NullPointerException("The specified array is null.");
        }
        if (!Long.class.isAssignableFrom(TArray.getClass().getComponentType()) && TArray.getClass().getComponentType() != Long.TYPE) {
            throw new ArrayStoreException("Type of the specified array is not a supertype of the runtime type of every element in this collection.");
        }
        int n = this.size();
        boolean bl = TArray.length > n;
        T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        ObjectsIterator objectsIterator = this.iterator();
        int n2 = 0;
        while (objectsIterator.hasNext()) {
            Long l = objectsIterator.next();
            TArray2[n2++] = l;
        }
        objectsIterator.close();
        if (bl) {
            TArray2[n] = null;
        }
        return TArray2;
    }

    @Override
    public Object[] toArray() {
        Long[] longArray = null;
        int n = this.size();
        if (n > 0) {
            longArray = new Long[n];
            ObjectsIterator objectsIterator = this.iterator();
            int n2 = 0;
            while (objectsIterator.hasNext()) {
                longArray[n2++] = objectsIterator.next();
            }
            objectsIterator.close();
        }
        return longArray;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException("This collection does not support null elements.");
        }
        if (object instanceof Long) {
            return this.exists((Long)object);
        }
        throw new ClassCastException("The specified element is incompatible with this collection.");
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0L;
    }

    @Override
    public int size() {
        long l = this.count();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static long getInvalidOID() {
        return dexjavawrapJNI.dex_gdb_Objects_InvalidOID_get();
    }

    public Objects copy() {
        long l = dexjavawrapJNI.dex_gdb_Objects_copy__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new Objects(l, true);
    }

    public long count() {
        return dexjavawrapJNI.dex_gdb_Objects_count(this.swigCPtr, this);
    }

    @Override
    public boolean add(long l) {
        return dexjavawrapJNI.dex_gdb_Objects_add(this.swigCPtr, this, l);
    }

    public boolean exists(long l) {
        return dexjavawrapJNI.dex_gdb_Objects_exists(this.swigCPtr, this, l);
    }

    public long any() throws NoSuchElementException {
        return dexjavawrapJNI.dex_gdb_Objects_any(this.swigCPtr, this);
    }

    public boolean remove(long l) {
        return dexjavawrapJNI.dex_gdb_Objects_remove(this.swigCPtr, this, l);
    }

    @Override
    public void clear() {
        dexjavawrapJNI.dex_gdb_Objects_clear(this.swigCPtr, this);
    }

    public long union(Objects objects) {
        return dexjavawrapJNI.dex_gdb_Objects_union(this.swigCPtr, this, Objects.getCPtr(objects), objects);
    }

    public long intersection(Objects objects) {
        return dexjavawrapJNI.dex_gdb_Objects_intersection(this.swigCPtr, this, Objects.getCPtr(objects), objects);
    }

    public long difference(Objects objects) {
        return dexjavawrapJNI.dex_gdb_Objects_difference(this.swigCPtr, this, Objects.getCPtr(objects), objects);
    }

    public static Objects combineUnion(Objects objects, Objects objects2) {
        long l = dexjavawrapJNI.dex_gdb_Objects_combineUnion(Objects.getCPtr(objects), objects, Objects.getCPtr(objects2), objects2);
        return l == 0L ? null : new Objects(l, true);
    }

    public static Objects combineIntersection(Objects objects, Objects objects2) {
        long l = dexjavawrapJNI.dex_gdb_Objects_combineIntersection(Objects.getCPtr(objects), objects, Objects.getCPtr(objects2), objects2);
        return l == 0L ? null : new Objects(l, true);
    }

    public static Objects combineDifference(Objects objects, Objects objects2) {
        long l = dexjavawrapJNI.dex_gdb_Objects_combineDifference(Objects.getCPtr(objects), objects, Objects.getCPtr(objects2), objects2);
        return l == 0L ? null : new Objects(l, true);
    }

    public long copy(Objects objects) {
        return dexjavawrapJNI.dex_gdb_Objects_copy__SWIG_1(this.swigCPtr, this, Objects.getCPtr(objects), objects);
    }

    public Objects sample(Objects objects, long l) {
        long l2 = dexjavawrapJNI.dex_gdb_Objects_sample(this.swigCPtr, this, Objects.getCPtr(objects), objects, l);
        return l2 == 0L ? null : new Objects(l2, true);
    }

    public ObjectsIterator iterator() {
        long l = dexjavawrapJNI.dex_gdb_Objects_iterator(this.swigCPtr, this);
        return l == 0L ? null : new ObjectsIterator(l, true);
    }

    public ObjectsIterator iteratorFromIndex(long l) {
        long l2 = dexjavawrapJNI.dex_gdb_Objects_iteratorFromIndex(this.swigCPtr, this, l);
        return l2 == 0L ? null : new ObjectsIterator(l2, true);
    }

    public ObjectsIterator iteratorFromElement(long l) {
        long l2 = dexjavawrapJNI.dex_gdb_Objects_iteratorFromElement(this.swigCPtr, this, l);
        return l2 == 0L ? null : new ObjectsIterator(l2, true);
    }
}

