/*
 * Decompiled with CFR 0.152.
 */
package com.sparsity.dex.gdb;

import com.sparsity.dex.gdb.Attribute;
import com.sparsity.dex.gdb.AttributeKind;
import com.sparsity.dex.gdb.AttributeList;
import com.sparsity.dex.gdb.AttributeStatistics;
import com.sparsity.dex.gdb.Condition;
import com.sparsity.dex.gdb.DataType;
import com.sparsity.dex.gdb.EdgeData;
import com.sparsity.dex.gdb.EdgesDirection;
import com.sparsity.dex.gdb.ExportManager;
import com.sparsity.dex.gdb.ExportType;
import com.sparsity.dex.gdb.Objects;
import com.sparsity.dex.gdb.TextStream;
import com.sparsity.dex.gdb.Type;
import com.sparsity.dex.gdb.TypeList;
import com.sparsity.dex.gdb.Value;
import com.sparsity.dex.gdb.Values;
import com.sparsity.dexjavawrapJNI;
import java.io.FileNotFoundException;

public class Graph {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public Graph(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Graph graph) {
        return graph == null ? 0L : graph.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                dexjavawrapJNI.delete_dex_gdb_Graph(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public int newNodeType(String string) {
        return dexjavawrapJNI.dex_gdb_Graph_newNodeType(this.swigCPtr, this, string);
    }

    public long newNode(int n) {
        return dexjavawrapJNI.dex_gdb_Graph_newNode(this.swigCPtr, this, n);
    }

    public int newEdgeType(String string, boolean bl, boolean bl2) {
        return dexjavawrapJNI.dex_gdb_Graph_newEdgeType(this.swigCPtr, this, string, bl, bl2);
    }

    public int newRestrictedEdgeType(String string, int n, int n2, boolean bl) {
        return dexjavawrapJNI.dex_gdb_Graph_newRestrictedEdgeType(this.swigCPtr, this, string, n, n2, bl);
    }

    public long newEdge(int n, long l, long l2) {
        return dexjavawrapJNI.dex_gdb_Graph_newEdge__SWIG_0(this.swigCPtr, this, n, l, l2);
    }

    public long newEdge(int n, int n2, Value value, int n3, Value value2) {
        return dexjavawrapJNI.dex_gdb_Graph_newEdge__SWIG_1(this.swigCPtr, this, n, n2, Value.getCPtr(value), value, n3, Value.getCPtr(value2), value2);
    }

    public long countNodes() {
        return dexjavawrapJNI.dex_gdb_Graph_countNodes(this.swigCPtr, this);
    }

    public long countEdges() {
        return dexjavawrapJNI.dex_gdb_Graph_countEdges(this.swigCPtr, this);
    }

    public EdgeData getEdgeData(long l) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_getEdgeData(this.swigCPtr, this, l);
        return l2 == 0L ? null : new EdgeData(l2, true);
    }

    public long getEdgePeer(long l, long l2) {
        return dexjavawrapJNI.dex_gdb_Graph_getEdgePeer(this.swigCPtr, this, l, l2);
    }

    public void drop(long l) {
        dexjavawrapJNI.dex_gdb_Graph_drop__SWIG_0(this.swigCPtr, this, l);
    }

    public void drop(Objects objects) {
        dexjavawrapJNI.dex_gdb_Graph_drop__SWIG_1(this.swigCPtr, this, Objects.getCPtr(objects), objects);
    }

    public int getObjectType(long l) {
        return dexjavawrapJNI.dex_gdb_Graph_getObjectType(this.swigCPtr, this, l);
    }

    public int newAttribute(int n, String string, DataType dataType, AttributeKind attributeKind) {
        return dexjavawrapJNI.dex_gdb_Graph_newAttribute__SWIG_0(this.swigCPtr, this, n, string, dataType.swigValue(), attributeKind.swigValue());
    }

    public int newAttribute(int n, String string, DataType dataType, AttributeKind attributeKind, Value value) {
        return dexjavawrapJNI.dex_gdb_Graph_newAttribute__SWIG_1(this.swigCPtr, this, n, string, dataType.swigValue(), attributeKind.swigValue(), Value.getCPtr(value), value);
    }

    public int newSessionAttribute(int n, DataType dataType, AttributeKind attributeKind) {
        return dexjavawrapJNI.dex_gdb_Graph_newSessionAttribute__SWIG_0(this.swigCPtr, this, n, dataType.swigValue(), attributeKind.swigValue());
    }

    public int newSessionAttribute(int n, DataType dataType, AttributeKind attributeKind, Value value) {
        return dexjavawrapJNI.dex_gdb_Graph_newSessionAttribute__SWIG_1(this.swigCPtr, this, n, dataType.swigValue(), attributeKind.swigValue(), Value.getCPtr(value), value);
    }

    public void setAttributeDefaultValue(int n, Value value) {
        dexjavawrapJNI.dex_gdb_Graph_setAttributeDefaultValue(this.swigCPtr, this, n, Value.getCPtr(value), value);
    }

    public void indexAttribute(int n, AttributeKind attributeKind) {
        dexjavawrapJNI.dex_gdb_Graph_indexAttribute(this.swigCPtr, this, n, attributeKind.swigValue());
    }

    public void getAttribute(long l, int n, Value value) {
        dexjavawrapJNI.dex_gdb_Graph_getAttribute__SWIG_0(this.swigCPtr, this, l, n, Value.getCPtr(value), value);
    }

    public Value getAttribute(long l, int n) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_getAttribute__SWIG_1(this.swigCPtr, this, l, n);
        return l2 == 0L ? null : new Value(l2, true);
    }

    public TextStream getAttributeText(long l, int n) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_getAttributeText(this.swigCPtr, this, l, n);
        return l2 == 0L ? null : new TextStream(l2, true);
    }

    public void setAttributeText(long l, int n, TextStream textStream) {
        dexjavawrapJNI.dex_gdb_Graph_setAttributeText(this.swigCPtr, this, l, n, TextStream.getCPtr(textStream), textStream);
    }

    public void setAttribute(long l, int n, Value value) {
        dexjavawrapJNI.dex_gdb_Graph_setAttribute(this.swigCPtr, this, l, n, Value.getCPtr(value), value);
    }

    public AttributeStatistics getAttributeStatistics(int n, boolean bl) {
        long l = dexjavawrapJNI.dex_gdb_Graph_getAttributeStatistics(this.swigCPtr, this, n, bl);
        return l == 0L ? null : new AttributeStatistics(l, true);
    }

    public long getAttributeIntervalCount(int n, Value value, boolean bl, Value value2, boolean bl2) {
        return dexjavawrapJNI.dex_gdb_Graph_getAttributeIntervalCount(this.swigCPtr, this, n, Value.getCPtr(value), value, bl, Value.getCPtr(value2), value2, bl2);
    }

    public int findType(String string) {
        return dexjavawrapJNI.dex_gdb_Graph_findType(this.swigCPtr, this, string);
    }

    public Type getType(int n) {
        long l = dexjavawrapJNI.dex_gdb_Graph_getType(this.swigCPtr, this, n);
        return l == 0L ? null : new Type(l, true);
    }

    public void removeType(int n) {
        dexjavawrapJNI.dex_gdb_Graph_removeType(this.swigCPtr, this, n);
    }

    public int findAttribute(int n, String string) {
        return dexjavawrapJNI.dex_gdb_Graph_findAttribute(this.swigCPtr, this, n, string);
    }

    public Attribute getAttribute(int n) {
        long l = dexjavawrapJNI.dex_gdb_Graph_getAttribute__SWIG_2(this.swigCPtr, this, n);
        return l == 0L ? null : new Attribute(l, true);
    }

    public void removeAttribute(int n) {
        dexjavawrapJNI.dex_gdb_Graph_removeAttribute(this.swigCPtr, this, n);
    }

    public long findObject(int n, Value value) {
        return dexjavawrapJNI.dex_gdb_Graph_findObject(this.swigCPtr, this, n, Value.getCPtr(value), value);
    }

    public Objects select(int n) {
        long l = dexjavawrapJNI.dex_gdb_Graph_select__SWIG_0(this.swigCPtr, this, n);
        return l == 0L ? null : new Objects(l, true);
    }

    public Objects select(int n, Condition condition, Value value) {
        long l = dexjavawrapJNI.dex_gdb_Graph_select__SWIG_1(this.swigCPtr, this, n, condition.swigValue(), Value.getCPtr(value), value);
        return l == 0L ? null : new Objects(l, true);
    }

    public Objects select(int n, Condition condition, Value value, Value value2) {
        long l = dexjavawrapJNI.dex_gdb_Graph_select__SWIG_2(this.swigCPtr, this, n, condition.swigValue(), Value.getCPtr(value), value, Value.getCPtr(value2), value2);
        return l == 0L ? null : new Objects(l, true);
    }

    public Objects explode(long l, int n, EdgesDirection edgesDirection) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_explode__SWIG_0(this.swigCPtr, this, l, n, edgesDirection.swigValue());
        return l2 == 0L ? null : new Objects(l2, true);
    }

    public Objects explode(Objects objects, int n, EdgesDirection edgesDirection) {
        long l = dexjavawrapJNI.dex_gdb_Graph_explode__SWIG_1(this.swigCPtr, this, Objects.getCPtr(objects), objects, n, edgesDirection.swigValue());
        return l == 0L ? null : new Objects(l, true);
    }

    public long degree(long l, int n, EdgesDirection edgesDirection) {
        return dexjavawrapJNI.dex_gdb_Graph_degree(this.swigCPtr, this, l, n, edgesDirection.swigValue());
    }

    public Objects neighbors(long l, int n, EdgesDirection edgesDirection) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_neighbors__SWIG_0(this.swigCPtr, this, l, n, edgesDirection.swigValue());
        return l2 == 0L ? null : new Objects(l2, true);
    }

    public Objects neighbors(Objects objects, int n, EdgesDirection edgesDirection) {
        long l = dexjavawrapJNI.dex_gdb_Graph_neighbors__SWIG_1(this.swigCPtr, this, Objects.getCPtr(objects), objects, n, edgesDirection.swigValue());
        return l == 0L ? null : new Objects(l, true);
    }

    public Objects edges(int n, long l, long l2) {
        long l3 = dexjavawrapJNI.dex_gdb_Graph_edges(this.swigCPtr, this, n, l, l2);
        return l3 == 0L ? null : new Objects(l3, true);
    }

    public long findEdge(int n, long l, long l2) {
        return dexjavawrapJNI.dex_gdb_Graph_findEdge(this.swigCPtr, this, n, l, l2);
    }

    public Objects tails(Objects objects) {
        long l = dexjavawrapJNI.dex_gdb_Graph_tails(this.swigCPtr, this, Objects.getCPtr(objects), objects);
        return l == 0L ? null : new Objects(l, true);
    }

    public Objects heads(Objects objects) {
        long l = dexjavawrapJNI.dex_gdb_Graph_heads(this.swigCPtr, this, Objects.getCPtr(objects), objects);
        return l == 0L ? null : new Objects(l, true);
    }

    public void tailsAndHeads(Objects objects, Objects objects2, Objects objects3) {
        dexjavawrapJNI.dex_gdb_Graph_tailsAndHeads(this.swigCPtr, this, Objects.getCPtr(objects), objects, Objects.getCPtr(objects2), objects2, Objects.getCPtr(objects3), objects3);
    }

    public TypeList findNodeTypes() {
        long l = dexjavawrapJNI.dex_gdb_Graph_findNodeTypes(this.swigCPtr, this);
        return l == 0L ? null : new TypeList(l, true);
    }

    public TypeList findEdgeTypes() {
        long l = dexjavawrapJNI.dex_gdb_Graph_findEdgeTypes(this.swigCPtr, this);
        return l == 0L ? null : new TypeList(l, true);
    }

    public TypeList findTypes() {
        long l = dexjavawrapJNI.dex_gdb_Graph_findTypes(this.swigCPtr, this);
        return l == 0L ? null : new TypeList(l, true);
    }

    public AttributeList findAttributes(int n) {
        long l = dexjavawrapJNI.dex_gdb_Graph_findAttributes(this.swigCPtr, this, n);
        return l == 0L ? null : new AttributeList(l, true);
    }

    public AttributeList getAttributes(long l) {
        long l2 = dexjavawrapJNI.dex_gdb_Graph_getAttributes(this.swigCPtr, this, l);
        return l2 == 0L ? null : new AttributeList(l2, true);
    }

    public Values getValues(int n) {
        long l = dexjavawrapJNI.dex_gdb_Graph_getValues(this.swigCPtr, this, n);
        return l == 0L ? null : new Values(l, true);
    }

    public void dumpData(String string) throws FileNotFoundException {
        dexjavawrapJNI.dex_gdb_Graph_dumpData(this.swigCPtr, this, string);
    }

    public void dumpStorage(String string) throws FileNotFoundException {
        dexjavawrapJNI.dex_gdb_Graph_dumpStorage(this.swigCPtr, this, string);
    }

    public void export(String string, ExportType exportType, ExportManager exportManager) {
        dexjavawrapJNI.dex_gdb_Graph_export(this.swigCPtr, this, string, exportType.swigValue(), ExportManager.getCPtr(exportManager), exportManager);
    }

    public void backup(String string) throws FileNotFoundException {
        dexjavawrapJNI.dex_gdb_Graph_backup(this.swigCPtr, this, string);
    }
}

