/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.actor.ActorManager;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.film.generated.GeneratedFilm;
import com.company.sakila.db0.sakila.language.Language;
import com.company.sakila.db0.sakila.language.LanguageManager;
import com.speedment.common.tuple.Tuples;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.field.trait.HasFinder;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class Join {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private final LanguageManager languages = (LanguageManager)this.app.getOrThrow(LanguageManager.class);
    private final ActorManager actors = (ActorManager)this.app.getOrThrow(ActorManager.class);

    public static void main(String[] args) {
        new Join().run();
    }

    private void run() {
        this.joinInMap();
        this.oneToMany();
        this.join();
        this.linked();
    }

    private void joinInMap() {
        ExampleUtil.log("joinInMap");
        Map languageFilmMap = this.films.stream().collect(Collectors.groupingBy(this.languages.finderBy((HasFinder)Film.LANGUAGE_ID)));
        languageFilmMap.forEach((l, fl) -> System.out.format("%s: %s%n", l.getName(), fl.stream().map(GeneratedFilm::getTitle).collect(Collectors.joining(", "))));
    }

    private void oneToMany() {
        ExampleUtil.log("oneToMany");
        this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"English"))).flatMap(this.films.finderBackwardsBy((HasFinder)Film.LANGUAGE_ID)).forEach(System.out::println);
    }

    private void join() {
        ExampleUtil.log("join");
        this.films.stream().filter(Film.RATING.in((Comparable[])new String[]{"G", "PG"})).map(f -> Tuples.of((Object)f, (Object)this.languages.findBy((HasFinder)Film.LANGUAGE_ID, f))).map(t2 -> String.format("The film '%s' is in %s", ((Film)t2.get0()).getTitle(), ((Language)t2.get1()).getName())).forEachOrdered(System.out::println);
    }

    private void linked() {
        ExampleUtil.log("linked");
        Optional anyFilmInEnglish = this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"english"))).flatMap(this.films.finderBackwardsBy((HasFinder)Film.LANGUAGE_ID)).findAny();
        Optional languageOfFilmWithId42 = this.films.stream().filter(Film.FILM_ID.equal((Comparable)Integer.valueOf(42))).map(this.languages.finderBy((HasFinder)Film.LANGUAGE_ID)).findAny();
    }
}

