/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.film.generated.GeneratedFilm;
import com.speedment.example.basic_example.util.ExampleUtil;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class Optimization {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);

    public static void main(String[] args) {
        new Optimization().run();
    }

    private void run() {
        this.findALongFilm();
        this.countPg13Films();
        this.understandingOptimization();
    }

    private void findALongFilm() {
        ExampleUtil.log("findALongFilm");
        Optional<Film> longFilm = this.films.stream().filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(120))).findAny();
        longFilm.ifPresent(System.out::println);
    }

    private void countPg13Films() {
        ExampleUtil.log("countPg13Films");
        long count = this.films.stream().filter(Film.RATING.equal((Comparable)((Object)"PG-13"))).count();
        System.out.format("There are %d films rated 'PG-13'%n", count);
    }

    private void understandingOptimization() {
        ExampleUtil.log("understandingOptimization");
        long count = this.films.stream().filter(Film.RATING.equal((Comparable)((Object)"PG-13"))).filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(75))).map(GeneratedFilm::getTitle).sorted().count();
        System.out.format("Found %d films%n", count);
    }
}

