/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.SakilaApplicationBuilder;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.core.ApplicationBuilder;
import java.util.stream.Stream;

public class RestBackEnd {
    private final SakilaApplication app = ExampleUtil.buildApplication(b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLogglerName)ApplicationBuilder.LogType.STREAM_OPTIMIZER));
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private static final int PAGE_SIZE = 50;

    public static void main(String[] args) {
        new RestBackEnd().run();
    }

    private void run() {
        this.serveFilms("PG-13", 0).forEach(System.out::println);
        this.serveFilms("PG-13", 1).forEach(System.out::println);
        this.serveFilms("PG-13", 3).forEach(System.out::println);
    }

    private Stream<Film> serveFilms(String rating, int page) {
        System.out.format("serveFilms(String rating=%s, int page=%d) %n", rating, page);
        Stream stream = this.films.stream();
        if (rating != null) {
            stream = stream.filter(Film.RATING.equal((Comparable)((Object)rating)));
        }
        return stream.sorted(Film.LENGTH.comparator()).skip(page * 50).limit(50L);
    }

    private Stream<Film> serveFilmsVariant(String rating, int page) {
        System.out.format("serveFilmsVariant(String rating=%s, int page=%d) %n", rating, page);
        Stream stream = this.films.stream().sorted(Film.LENGTH.comparator().reversed()).sorted(Film.RELEASE_YEAR.comparator()).filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(2)));
        if (rating != null) {
            stream = stream.filter(Film.RATING.equal((Comparable)((Object)rating)));
        }
        return stream.skip(page * 50).limit(50L);
    }

    private Stream<Film> serveFilmsWithfunctionalFold(String rating, int page) {
        System.out.format("serveFilmsWithfunctionalFold(String rating=%s, int page=%d) %n", rating, page);
        return Stream.of(s -> rating == null ? s : s.filter(Film.RATING.equal((Comparable)((Object)rating))), s -> s.sorted(Film.LENGTH.comparator()), s -> s.skip(page * 50), s -> s.limit(50L)).reduce(this.films.stream(), (s, o) -> (Stream)o.apply(s), (a, b) -> a);
    }
}

