/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.SakilaApplicationBuilder;
import com.company.sakila.db0.sakila.language.Language;
import com.company.sakila.db0.sakila.language.LanguageImpl;
import com.company.sakila.db0.sakila.language.LanguageManager;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.core.ApplicationBuilder;

public class Crud {
    private final SakilaApplication app = ExampleUtil.buildApplication(b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLogglerName)ApplicationBuilder.LogType.PERSIST), b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLogglerName)ApplicationBuilder.LogType.UPDATE), b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLogglerName)ApplicationBuilder.LogType.REMOVE));
    private final LanguageManager languages = (LanguageManager)this.app.getOrThrow(LanguageManager.class);

    public static void main(String[] args) {
        new Crud().run();
    }

    private void run() {
        this.printAllLanguages();
        this.create();
        this.printAllLanguages();
        this.update();
        this.printAllLanguages();
        this.remove();
        this.printAllLanguages();
    }

    private void create() {
        ExampleUtil.log("create");
        Language german = (Language)this.languages.persist(new LanguageImpl().setName("Deutsch"));
        System.out.format("Language %s was persisted with id %d %n", german.getName(), german.getLanguageId());
    }

    private void update() {
        ExampleUtil.log("update");
        this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"Deutsch"))).map(Language.NAME.setTo((Object)"German")).forEach(this.languages.updater());
    }

    private void remove() {
        ExampleUtil.log("remove");
        this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"German"))).forEach(this.languages.remover());
    }

    private void printAllLanguages() {
        this.languages.stream().forEachOrdered(System.out::println);
    }
}

