/*
 * Decompiled with CFR 0.152.
 */
package com.company.sakila.db0.sakila.payment.generated;

import com.company.sakila.db0.sakila.customer.Customer;
import com.company.sakila.db0.sakila.payment.Payment;
import com.company.sakila.db0.sakila.rental.Rental;
import com.company.sakila.db0.sakila.staff.Staff;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.StringJoiner;

public abstract class GeneratedPaymentImpl
implements Payment {
    private int paymentId;
    private int customerId;
    private short staffId;
    private Integer rentalId;
    private BigDecimal amount;
    private Timestamp paymentDate;
    private Timestamp lastUpdate;

    protected GeneratedPaymentImpl() {
    }

    @Override
    public int getPaymentId() {
        return this.paymentId;
    }

    @Override
    public int getCustomerId() {
        return this.customerId;
    }

    @Override
    public short getStaffId() {
        return this.staffId;
    }

    @Override
    public OptionalInt getRentalId() {
        return OptionalUtil.ofNullable((Integer)this.rentalId);
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public Timestamp getPaymentDate() {
        return this.paymentDate;
    }

    @Override
    public Timestamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public Payment setPaymentId(int paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @Override
    public Payment setCustomerId(int customerId) {
        this.customerId = customerId;
        return this;
    }

    @Override
    public Payment setStaffId(short staffId) {
        this.staffId = staffId;
        return this;
    }

    @Override
    public Payment setRentalId(Integer rentalId) {
        this.rentalId = rentalId;
        return this;
    }

    @Override
    public Payment setAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public Payment setPaymentDate(Timestamp paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Override
    public Payment setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    public Customer findCustomerId(Manager<Customer> foreignManager) {
        return foreignManager.stream().filter(Customer.CUSTOMER_ID.equal((Comparable)Integer.valueOf(this.getCustomerId()))).findAny().orElse(null);
    }

    @Override
    public Staff findStaffId(Manager<Staff> foreignManager) {
        return foreignManager.stream().filter(Staff.STAFF_ID.equal((Comparable)Short.valueOf(this.getStaffId()))).findAny().orElse(null);
    }

    @Override
    public Optional<Rental> findRentalId(Manager<Rental> foreignManager) {
        if (this.getRentalId().isPresent()) {
            return foreignManager.stream().filter(Rental.RENTAL_ID.equal((Comparable)Integer.valueOf(this.getRentalId().getAsInt()))).findAny();
        }
        return Optional.empty();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{ ", " }");
        sj.add("paymentId = " + Objects.toString(this.getPaymentId()));
        sj.add("customerId = " + Objects.toString(this.getCustomerId()));
        sj.add("staffId = " + Objects.toString(this.getStaffId()));
        sj.add("rentalId = " + Objects.toString(OptionalUtil.unwrap((OptionalInt)this.getRentalId())));
        sj.add("amount = " + Objects.toString(this.getAmount()));
        sj.add("paymentDate = " + Objects.toString(this.getPaymentDate()));
        sj.add("lastUpdate = " + Objects.toString(this.getLastUpdate()));
        return "PaymentImpl " + sj.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Payment)) {
            return false;
        }
        Payment thatPayment = (Payment)that;
        if (this.getPaymentId() != thatPayment.getPaymentId()) {
            return false;
        }
        if (this.getCustomerId() != thatPayment.getCustomerId()) {
            return false;
        }
        if (this.getStaffId() != thatPayment.getStaffId()) {
            return false;
        }
        if (!Objects.equals(this.getRentalId(), thatPayment.getRentalId())) {
            return false;
        }
        if (!Objects.equals(this.getAmount(), thatPayment.getAmount())) {
            return false;
        }
        if (!Objects.equals(this.getPaymentDate(), thatPayment.getPaymentDate())) {
            return false;
        }
        return Objects.equals(this.getLastUpdate(), thatPayment.getLastUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Integer.hashCode(this.getPaymentId());
        hash = 31 * hash + Integer.hashCode(this.getCustomerId());
        hash = 31 * hash + Short.hashCode(this.getStaffId());
        hash = 31 * hash + Objects.hashCode(OptionalUtil.unwrap((OptionalInt)this.getRentalId()));
        hash = 31 * hash + Objects.hashCode(this.getAmount());
        hash = 31 * hash + Objects.hashCode(this.getPaymentDate());
        hash = 31 * hash + Objects.hashCode(this.getLastUpdate());
        return hash;
    }
}

