/*
 * Decompiled with CFR 0.152.
 */
package com.company.sakila.db0.sakila.rental.generated;

import com.company.sakila.db0.sakila.customer.Customer;
import com.company.sakila.db0.sakila.inventory.Inventory;
import com.company.sakila.db0.sakila.rental.Rental;
import com.company.sakila.db0.sakila.staff.Staff;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public abstract class GeneratedRentalImpl
implements Rental {
    private int rentalId;
    private Timestamp rentalDate;
    private int inventoryId;
    private int customerId;
    private Timestamp returnDate;
    private short staffId;
    private Timestamp lastUpdate;

    protected GeneratedRentalImpl() {
    }

    @Override
    public int getRentalId() {
        return this.rentalId;
    }

    @Override
    public Timestamp getRentalDate() {
        return this.rentalDate;
    }

    @Override
    public int getInventoryId() {
        return this.inventoryId;
    }

    @Override
    public int getCustomerId() {
        return this.customerId;
    }

    @Override
    public Optional<Timestamp> getReturnDate() {
        return Optional.ofNullable(this.returnDate);
    }

    @Override
    public short getStaffId() {
        return this.staffId;
    }

    @Override
    public Timestamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public Rental setRentalId(int rentalId) {
        this.rentalId = rentalId;
        return this;
    }

    @Override
    public Rental setRentalDate(Timestamp rentalDate) {
        this.rentalDate = rentalDate;
        return this;
    }

    @Override
    public Rental setInventoryId(int inventoryId) {
        this.inventoryId = inventoryId;
        return this;
    }

    @Override
    public Rental setCustomerId(int customerId) {
        this.customerId = customerId;
        return this;
    }

    @Override
    public Rental setReturnDate(Timestamp returnDate) {
        this.returnDate = returnDate;
        return this;
    }

    @Override
    public Rental setStaffId(short staffId) {
        this.staffId = staffId;
        return this;
    }

    @Override
    public Rental setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    public Inventory findInventoryId(Manager<Inventory> foreignManager) {
        return foreignManager.stream().filter(Inventory.INVENTORY_ID.equal((Comparable)Integer.valueOf(this.getInventoryId()))).findAny().orElse(null);
    }

    @Override
    public Customer findCustomerId(Manager<Customer> foreignManager) {
        return foreignManager.stream().filter(Customer.CUSTOMER_ID.equal((Comparable)Integer.valueOf(this.getCustomerId()))).findAny().orElse(null);
    }

    @Override
    public Staff findStaffId(Manager<Staff> foreignManager) {
        return foreignManager.stream().filter(Staff.STAFF_ID.equal((Comparable)Short.valueOf(this.getStaffId()))).findAny().orElse(null);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{ ", " }");
        sj.add("rentalId = " + Objects.toString(this.getRentalId()));
        sj.add("rentalDate = " + Objects.toString(this.getRentalDate()));
        sj.add("inventoryId = " + Objects.toString(this.getInventoryId()));
        sj.add("customerId = " + Objects.toString(this.getCustomerId()));
        sj.add("returnDate = " + Objects.toString(OptionalUtil.unwrap(this.getReturnDate())));
        sj.add("staffId = " + Objects.toString(this.getStaffId()));
        sj.add("lastUpdate = " + Objects.toString(this.getLastUpdate()));
        return "RentalImpl " + sj.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Rental)) {
            return false;
        }
        Rental thatRental = (Rental)that;
        if (this.getRentalId() != thatRental.getRentalId()) {
            return false;
        }
        if (!Objects.equals(this.getRentalDate(), thatRental.getRentalDate())) {
            return false;
        }
        if (this.getInventoryId() != thatRental.getInventoryId()) {
            return false;
        }
        if (this.getCustomerId() != thatRental.getCustomerId()) {
            return false;
        }
        if (!Objects.equals(this.getReturnDate(), thatRental.getReturnDate())) {
            return false;
        }
        if (this.getStaffId() != thatRental.getStaffId()) {
            return false;
        }
        return Objects.equals(this.getLastUpdate(), thatRental.getLastUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Integer.hashCode(this.getRentalId());
        hash = 31 * hash + Objects.hashCode(this.getRentalDate());
        hash = 31 * hash + Integer.hashCode(this.getInventoryId());
        hash = 31 * hash + Integer.hashCode(this.getCustomerId());
        hash = 31 * hash + Objects.hashCode(OptionalUtil.unwrap(this.getReturnDate()));
        hash = 31 * hash + Short.hashCode(this.getStaffId());
        hash = 31 * hash + Objects.hashCode(this.getLastUpdate());
        return hash;
    }
}

