/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.actor.Actor;
import com.company.sakila.db0.sakila.actor.ActorManager;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.film_actor.FilmActor;
import com.company.sakila.db0.sakila.film_actor.FilmActorManager;
import com.speedment.common.tuple.Tuple3;
import com.speedment.common.tuple.Tuples;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.join.Join;
import com.speedment.runtime.join.JoinComponent;
import com.speedment.runtime.join.builder.JoinBuilder2;
import com.speedment.runtime.join.builder.JoinBuilder3;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class Pivot {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private final ActorManager actors = (ActorManager)this.app.getOrThrow(ActorManager.class);
    private final FilmActorManager filmActors = (FilmActorManager)this.app.getOrThrow(FilmActorManager.class);
    private final JoinComponent joinComponent = (JoinComponent)this.app.getOrThrow(JoinComponent.class);

    public static void main(String[] args) {
        new Pivot().run();
    }

    private void run() {
        this.pivot();
        this.pivotCustom();
    }

    private void pivot() {
        ExampleUtil.log("pivot");
        Join join = ((JoinBuilder3)((JoinBuilder2)this.joinComponent.from(FilmActorManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.FILM_ID).equal((HasComparableOperators)FilmActor.FILM_ID)).innerJoinOn((HasComparableOperators)Actor.ACTOR_ID).equal((HasComparableOperators)FilmActor.ACTOR_ID)).build(Tuples::of);
        Map<Actor, Map<String, Long>> pivot = join.stream().collect(Collectors.groupingBy(Tuple3::get2, Collectors.groupingBy(tu -> ((Film)tu.get1()).getRating().get(), Collectors.counting())));
        pivot.forEach((k, v) -> System.out.format("%22s  %5s %n", k.getFirstName() + " " + k.getLastName(), v));
    }

    private void pivotCustom() {
        ExampleUtil.log("pivotCustom");
        Join join = ((JoinBuilder3)((JoinBuilder2)this.joinComponent.from(FilmActorManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.FILM_ID).equal((HasComparableOperators)FilmActor.FILM_ID)).innerJoinOn((HasComparableOperators)Actor.ACTOR_ID).equal((HasComparableOperators)FilmActor.ACTOR_ID)).build((x$0, x$1, x$2) -> new ActorRating((FilmActor)x$0, (Film)x$1, (Actor)x$2));
        Map<Actor, Map<String, Long>> pivot = join.stream().collect(Collectors.groupingBy(ActorRating::actor, Collectors.groupingBy(ActorRating::rating, Collectors.counting())));
        pivot.forEach((k, v) -> System.out.format("%22s  %5s %n", k.getFirstName() + " " + k.getLastName(), v));
    }

    private static class ActorRating {
        private final Actor actor;
        private final String rating;

        private ActorRating(FilmActor fa, Film film, Actor actor) {
            this.actor = actor;
            this.rating = film.getRating().orElseThrow(NoSuchElementException::new);
        }

        public Actor actor() {
            return this.actor;
        }

        public String rating() {
            return this.rating;
        }
    }
}

