/*
 * Decompiled with CFR 0.152.
 */
package com.company.sakila.db0.sakila.film.generated;

import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.language.Language;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.StringJoiner;

public abstract class GeneratedFilmImpl
implements Film {
    private int filmId;
    private String title;
    private String description;
    private Date releaseYear;
    private short languageId;
    private Short originalLanguageId;
    private short rentalDuration;
    private BigDecimal rentalRate;
    private Integer length;
    private BigDecimal replacementCost;
    private String rating;
    private String specialFeatures;
    private Timestamp lastUpdate;

    protected GeneratedFilmImpl() {
    }

    @Override
    public int getFilmId() {
        return this.filmId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Optional<Date> getReleaseYear() {
        return Optional.ofNullable(this.releaseYear);
    }

    @Override
    public short getLanguageId() {
        return this.languageId;
    }

    @Override
    public Optional<Short> getOriginalLanguageId() {
        return Optional.ofNullable(this.originalLanguageId);
    }

    @Override
    public short getRentalDuration() {
        return this.rentalDuration;
    }

    @Override
    public BigDecimal getRentalRate() {
        return this.rentalRate;
    }

    @Override
    public OptionalInt getLength() {
        return OptionalUtil.ofNullable((Integer)this.length);
    }

    @Override
    public BigDecimal getReplacementCost() {
        return this.replacementCost;
    }

    @Override
    public Optional<String> getRating() {
        return Optional.ofNullable(this.rating);
    }

    @Override
    public Optional<String> getSpecialFeatures() {
        return Optional.ofNullable(this.specialFeatures);
    }

    @Override
    public Timestamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public Film setFilmId(int filmId) {
        this.filmId = filmId;
        return this;
    }

    @Override
    public Film setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Film setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Film setReleaseYear(Date releaseYear) {
        this.releaseYear = releaseYear;
        return this;
    }

    @Override
    public Film setLanguageId(short languageId) {
        this.languageId = languageId;
        return this;
    }

    @Override
    public Film setOriginalLanguageId(Short originalLanguageId) {
        this.originalLanguageId = originalLanguageId;
        return this;
    }

    @Override
    public Film setRentalDuration(short rentalDuration) {
        this.rentalDuration = rentalDuration;
        return this;
    }

    @Override
    public Film setRentalRate(BigDecimal rentalRate) {
        this.rentalRate = rentalRate;
        return this;
    }

    @Override
    public Film setLength(Integer length) {
        this.length = length;
        return this;
    }

    @Override
    public Film setReplacementCost(BigDecimal replacementCost) {
        this.replacementCost = replacementCost;
        return this;
    }

    @Override
    public Film setRating(String rating) {
        this.rating = rating;
        return this;
    }

    @Override
    public Film setSpecialFeatures(String specialFeatures) {
        this.specialFeatures = specialFeatures;
        return this;
    }

    @Override
    public Film setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    public Language findLanguageId(Manager<Language> foreignManager) {
        return foreignManager.stream().filter(Language.LANGUAGE_ID.equal((Comparable)Short.valueOf(this.getLanguageId()))).findAny().orElse(null);
    }

    @Override
    public Optional<Language> findOriginalLanguageId(Manager<Language> foreignManager) {
        if (this.getOriginalLanguageId().isPresent()) {
            return foreignManager.stream().filter(Language.LANGUAGE_ID.equal((Comparable)this.getOriginalLanguageId().get())).findAny();
        }
        return Optional.empty();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{ ", " }");
        sj.add("filmId = " + Objects.toString(this.getFilmId()));
        sj.add("title = " + Objects.toString(this.getTitle()));
        sj.add("description = " + Objects.toString(OptionalUtil.unwrap(this.getDescription())));
        sj.add("releaseYear = " + Objects.toString(OptionalUtil.unwrap(this.getReleaseYear())));
        sj.add("languageId = " + Objects.toString(this.getLanguageId()));
        sj.add("originalLanguageId = " + Objects.toString(OptionalUtil.unwrap(this.getOriginalLanguageId())));
        sj.add("rentalDuration = " + Objects.toString(this.getRentalDuration()));
        sj.add("rentalRate = " + Objects.toString(this.getRentalRate()));
        sj.add("length = " + Objects.toString(OptionalUtil.unwrap((OptionalInt)this.getLength())));
        sj.add("replacementCost = " + Objects.toString(this.getReplacementCost()));
        sj.add("rating = " + Objects.toString(OptionalUtil.unwrap(this.getRating())));
        sj.add("specialFeatures = " + Objects.toString(OptionalUtil.unwrap(this.getSpecialFeatures())));
        sj.add("lastUpdate = " + Objects.toString(this.getLastUpdate()));
        return "FilmImpl " + sj.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Film)) {
            return false;
        }
        Film thatFilm = (Film)that;
        if (this.getFilmId() != thatFilm.getFilmId()) {
            return false;
        }
        if (!Objects.equals(this.getTitle(), thatFilm.getTitle())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), thatFilm.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.getReleaseYear(), thatFilm.getReleaseYear())) {
            return false;
        }
        if (this.getLanguageId() != thatFilm.getLanguageId()) {
            return false;
        }
        if (!Objects.equals(this.getOriginalLanguageId(), thatFilm.getOriginalLanguageId())) {
            return false;
        }
        if (this.getRentalDuration() != thatFilm.getRentalDuration()) {
            return false;
        }
        if (!Objects.equals(this.getRentalRate(), thatFilm.getRentalRate())) {
            return false;
        }
        if (!Objects.equals(this.getLength(), thatFilm.getLength())) {
            return false;
        }
        if (!Objects.equals(this.getReplacementCost(), thatFilm.getReplacementCost())) {
            return false;
        }
        if (!Objects.equals(this.getRating(), thatFilm.getRating())) {
            return false;
        }
        if (!Objects.equals(this.getSpecialFeatures(), thatFilm.getSpecialFeatures())) {
            return false;
        }
        return Objects.equals(this.getLastUpdate(), thatFilm.getLastUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Integer.hashCode(this.getFilmId());
        hash = 31 * hash + Objects.hashCode(this.getTitle());
        hash = 31 * hash + Objects.hashCode(this.getDescription());
        hash = 31 * hash + Objects.hashCode(this.getReleaseYear());
        hash = 31 * hash + Short.hashCode(this.getLanguageId());
        hash = 31 * hash + Objects.hashCode(this.getOriginalLanguageId());
        hash = 31 * hash + Short.hashCode(this.getRentalDuration());
        hash = 31 * hash + Objects.hashCode(this.getRentalRate());
        hash = 31 * hash + Objects.hashCode(this.getLength());
        hash = 31 * hash + Objects.hashCode(this.getReplacementCost());
        hash = 31 * hash + Objects.hashCode(this.getRating());
        hash = 31 * hash + Objects.hashCode(this.getSpecialFeatures());
        hash = 31 * hash + Objects.hashCode(this.getLastUpdate());
        return hash;
    }
}

