/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example.extra;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.speedment.common.tuple.Tuples;
import com.speedment.example.basic_example.util.ExampleUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class UsersGuide {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);

    public static void main(String[] args) {
        new UsersGuide().run();
    }

    private void run() {
        this.distinct();
        this.mapToInt();
        this.mapToTuple();
        this.findId();
    }

    private void distinct() {
        Set ratings = this.films.stream().map(Film.RATING).distinct().collect(Collectors.toSet());
        System.out.println(ratings);
    }

    private void mapToInt() {
        IntStream ids = this.films.stream().mapToInt(Film.FILM_ID);
        ids.forEach(System.out::println);
    }

    private void mapToTuple() {
        Stream items = this.films.stream().map(Tuples.toTuple((Function)Film.TITLE, (Function)Film.LENGTH.getter()));
        items.forEach(System.out::println);
    }

    private void findId() {
        int id = 100;
        Optional title = this.films.stream().filter(Film.FILM_ID.equal((Comparable)Integer.valueOf(id))).map(Film.TITLE).findAny();
        if (title.isPresent()) {
            System.out.format("Film ID %d has title %s.", id, title.get());
        } else {
            System.out.format("Film ID not found.", id);
        }
    }
}

