/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.actor.ActorManager;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.film_actor.FilmActorManager;
import com.company.sakila.db0.sakila.language.Language;
import com.company.sakila.db0.sakila.language.LanguageManager;
import com.speedment.common.tuple.Tuples;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.field.trait.HasFinder;
import java.util.function.UnaryOperator;

public class Json {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private final FilmActorManager filmActors = (FilmActorManager)this.app.getOrThrow(FilmActorManager.class);
    private final ActorManager actors = (ActorManager)this.app.getOrThrow(ActorManager.class);
    private final LanguageManager languages = (LanguageManager)this.app.getOrThrow(LanguageManager.class);

    public static void main(String[] args) {
        new Json().run();
    }

    private void run() {
        this.oneToMany();
        this.manyToMany();
        this.join();
    }

    private void oneToMany() {
        ExampleUtil.log("oneToMany");
        this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"English"))).flatMap(this.films.finderBackwardsBy((HasFinder)Film.LANGUAGE_ID)).forEach(System.out::println);
    }

    private void manyToMany() {
        ExampleUtil.log("manyToMany");
        this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"English"))).flatMap(this.films.finderBackwardsBy((HasFinder)Film.LANGUAGE_ID)).forEach(System.out::println);
    }

    private void join() {
        ExampleUtil.log("join");
        this.films.stream().filter(Film.RATING.in((Comparable[])new String[]{"G", "PG"})).map(f -> Tuples.of((Object)f, (Object)this.languages.findBy((HasFinder)Film.LANGUAGE_ID, f))).map(t2 -> String.format("The film '%s' is in %s", ((Film)t2.get0()).getTitle(), ((Language)t2.get1()).getName())).forEachOrdered(System.out::println);
    }
}

