/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.address.AddressManager;
import com.speedment.example.basic_example.util.ExampleUtil;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.UnaryOperator;

public class PrintAddresses {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final AddressManager addresses = (AddressManager)this.app.getOrThrow(AddressManager.class);

    public static void main(String[] args) {
        new PrintAddresses().run();
    }

    private void run() {
        this.printAll();
        this.printAllMapped();
    }

    private void printAll() {
        ExampleUtil.log("printAll");
        this.addresses.stream().forEach(System.out::println);
    }

    private void printAllMapped() {
        ExampleUtil.log("printAll");
        this.addresses.stream().forEach(a -> System.out.format("Address %s, location Blob bytes %s %n", a.getAddress(), this.len(a.getLocation())));
    }

    private long len(Blob blob) {
        try {
            return blob.length();
        }
        catch (SQLException sqle) {
            return -1L;
        }
    }
}

