/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example.util;

import com.company.sakila.SakilaApplication;
import com.company.sakila.SakilaApplicationBuilder;
import com.speedment.runtime.core.ApplicationBuilder;
import java.util.Scanner;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class ExampleUtil {
    private static final String DEFAULT_PASSWORD = "sakila-password";

    @SafeVarargs
    public static SakilaApplication buildApplication(UnaryOperator<SakilaApplicationBuilder> ... operators) {
        System.out.println("Connecting to a MySQL database on 'localhost:3306'");
        System.out.println("Enter password (<return> = 'sakila-password'): ");
        Scanner scan = new Scanner(System.in);
        String inputPassword = scan.nextLine();
        String password = inputPassword.isEmpty() ? DEFAULT_PASSWORD : inputPassword;
        SakilaApplicationBuilder builder = (SakilaApplicationBuilder)((SakilaApplicationBuilder)new SakilaApplicationBuilder().withLogging((ApplicationBuilder.HasLoggerName)ApplicationBuilder.LogType.STREAM)).withPassword(password);
        Stream.of(operators).reduce(builder, (b, o) -> (SakilaApplicationBuilder)((Object)((Object)o.apply(b))), (a, b) -> a);
        return (SakilaApplication)builder.build();
    }

    public static <T> void printStream(Stream<T> stream) {
        stream.forEachOrdered(System.out::println);
    }

    public static void log(String testName) {
        System.out.format("*** Starting example \"%s\" ***%n", testName);
    }

    private ExampleUtil() {
    }
}

