/*
 * Decompiled with CFR 0.152.
 */
package com.company.sakila.db0.sakila.customer.generated;

import com.company.sakila.db0.sakila.address.Address;
import com.company.sakila.db0.sakila.customer.Customer;
import com.company.sakila.db0.sakila.store.Store;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public abstract class GeneratedCustomerImpl
implements Customer {
    private int customerId;
    private short storeId;
    private String firstName;
    private String lastName;
    private String email;
    private int addressId;
    private int active;
    private Timestamp createDate;
    private Timestamp lastUpdate;

    protected GeneratedCustomerImpl() {
    }

    @Override
    public int getCustomerId() {
        return this.customerId;
    }

    @Override
    public short getStoreId() {
        return this.storeId;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    @Override
    public int getAddressId() {
        return this.addressId;
    }

    @Override
    public int getActive() {
        return this.active;
    }

    @Override
    public Timestamp getCreateDate() {
        return this.createDate;
    }

    @Override
    public Timestamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public Customer setCustomerId(int customerId) {
        this.customerId = customerId;
        return this;
    }

    @Override
    public Customer setStoreId(short storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public Customer setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Override
    public Customer setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Override
    public Customer setEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    public Customer setAddressId(int addressId) {
        this.addressId = addressId;
        return this;
    }

    @Override
    public Customer setActive(int active) {
        this.active = active;
        return this;
    }

    @Override
    public Customer setCreateDate(Timestamp createDate) {
        this.createDate = createDate;
        return this;
    }

    @Override
    public Customer setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Override
    public Store findStoreId(Manager<Store> foreignManager) {
        return foreignManager.stream().filter(Store.STORE_ID.equal((Comparable)Short.valueOf(this.getStoreId()))).findAny().orElse(null);
    }

    @Override
    public Address findAddressId(Manager<Address> foreignManager) {
        return foreignManager.stream().filter(Address.ADDRESS_ID.equal((Comparable)Integer.valueOf(this.getAddressId()))).findAny().orElse(null);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{ ", " }");
        sj.add("customerId = " + Objects.toString(this.getCustomerId()));
        sj.add("storeId = " + Objects.toString(this.getStoreId()));
        sj.add("firstName = " + Objects.toString(this.getFirstName()));
        sj.add("lastName = " + Objects.toString(this.getLastName()));
        sj.add("email = " + Objects.toString(OptionalUtil.unwrap(this.getEmail())));
        sj.add("addressId = " + Objects.toString(this.getAddressId()));
        sj.add("active = " + Objects.toString(this.getActive()));
        sj.add("createDate = " + Objects.toString(this.getCreateDate()));
        sj.add("lastUpdate = " + Objects.toString(this.getLastUpdate()));
        return "CustomerImpl " + sj.toString();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Customer)) {
            return false;
        }
        Customer thatCustomer = (Customer)that;
        if (this.getCustomerId() != thatCustomer.getCustomerId()) {
            return false;
        }
        if (this.getStoreId() != thatCustomer.getStoreId()) {
            return false;
        }
        if (!Objects.equals(this.getFirstName(), thatCustomer.getFirstName())) {
            return false;
        }
        if (!Objects.equals(this.getLastName(), thatCustomer.getLastName())) {
            return false;
        }
        if (!Objects.equals(this.getEmail(), thatCustomer.getEmail())) {
            return false;
        }
        if (this.getAddressId() != thatCustomer.getAddressId()) {
            return false;
        }
        if (this.getActive() != thatCustomer.getActive()) {
            return false;
        }
        if (!Objects.equals(this.getCreateDate(), thatCustomer.getCreateDate())) {
            return false;
        }
        return Objects.equals(this.getLastUpdate(), thatCustomer.getLastUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Integer.hashCode(this.getCustomerId());
        hash = 31 * hash + Short.hashCode(this.getStoreId());
        hash = 31 * hash + Objects.hashCode(this.getFirstName());
        hash = 31 * hash + Objects.hashCode(this.getLastName());
        hash = 31 * hash + Objects.hashCode(this.getEmail());
        hash = 31 * hash + Integer.hashCode(this.getAddressId());
        hash = 31 * hash + Integer.hashCode(this.getActive());
        hash = 31 * hash + Objects.hashCode(this.getCreateDate());
        hash = 31 * hash + Objects.hashCode(this.getLastUpdate());
        return hash;
    }
}

