/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.db0.sakila.actor.Actor;
import com.company.sakila.db0.sakila.actor.ActorManager;
import com.company.sakila.db0.sakila.city.City;
import com.company.sakila.db0.sakila.city.CityManager;
import com.company.sakila.db0.sakila.country.Country;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.film.generated.GeneratedFilm;
import com.company.sakila.db0.sakila.film_actor.FilmActor;
import com.company.sakila.db0.sakila.film_actor.FilmActorManager;
import com.company.sakila.db0.sakila.language.Language;
import com.company.sakila.db0.sakila.language.LanguageManager;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.field.trait.HasComparableOperators;
import com.speedment.runtime.field.trait.HasFinder;
import com.speedment.runtime.join.Join;
import com.speedment.runtime.join.JoinComponent;
import com.speedment.runtime.join.builder.JoinBuilder1;
import com.speedment.runtime.join.builder.JoinBuilder2;
import com.speedment.runtime.join.builder.JoinBuilder3;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class JoinExamples {
    private final SakilaApplication app = ExampleUtil.buildApplication(new UnaryOperator[0]);
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private final LanguageManager languages = (LanguageManager)this.app.getOrThrow(LanguageManager.class);
    private final ActorManager actors = (ActorManager)this.app.getOrThrow(ActorManager.class);
    private final JoinComponent joinComponent = (JoinComponent)this.app.getOrThrow(JoinComponent.class);

    public static void main(String[] args) {
        new JoinExamples().run();
    }

    private void run() {
        this.crossJoin();
        this.crossJoinWithFiltering();
        this.leftJoin();
        this.joinInMap();
        this.joinInMapEntity();
        this.oneToMany();
        this.oneToManyDefaultConstructor();
        this.oneToManyCustomConstructor();
        this.manyToOne();
        this.manyToMany();
        this.manyToManySkipLinkTable();
        this.join();
        this.linked();
        this.selfJoin();
    }

    private void crossJoin() {
        ExampleUtil.log("crossJoin");
        Join join = this.joinComponent.from(FilmManager.IDENTIFIER).crossJoin(LanguageManager.IDENTIFIER).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void crossJoinWithFiltering() {
        ExampleUtil.log("crossJoinWithFiltering");
        Join join = ((JoinBuilder2)((JoinBuilder1)this.joinComponent.from(FilmManager.IDENTIFIER).where((Predicate)Film.RATING.equal((Comparable)((Object)"PG-13")))).crossJoin(LanguageManager.IDENTIFIER).where((Predicate)Language.NAME.equal((Comparable)((Object)"English")))).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void leftJoin() {
        ExampleUtil.log("leftJoin");
        Join join = ((JoinBuilder2)((JoinBuilder2)this.joinComponent.from(CityManager.IDENTIFIER).leftJoinOn((HasComparableOperators)Country.COUNTRY_ID).equal((HasComparableOperators)City.COUNTRY_ID)).where((Predicate)Country.COUNTRY.startsWith("A"))).build();
        join.stream().forEach(System.out::println);
    }

    private void joinInMap() {
        ExampleUtil.log("joinInMap");
        Join join = ((JoinBuilder2)this.joinComponent.from(FilmManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Language.LANGUAGE_ID).equal((HasComparableOperators)Film.LANGUAGE_ID)).build(Tuples::of);
        Map<Language, List<Tuple2>> languageFilmMap = join.stream().collect(Collectors.groupingBy(Tuple2::get1));
    }

    private void joinInMapEntity() {
        ExampleUtil.log("joinInMapEntity");
        Join join = ((JoinBuilder2)this.joinComponent.from(FilmManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Language.LANGUAGE_ID).equal((HasComparableOperators)Film.LANGUAGE_ID)).build(Tuples::of);
        Map languageFilmMap2 = join.stream().collect(Collectors.groupingBy(Tuple2::get1, Collectors.mapping(Tuple2::get0, Collectors.toList())));
        languageFilmMap2.forEach((l, fl) -> System.out.format("%s: %s %n", l.getName(), fl.stream().map(GeneratedFilm::getTitle).collect(Collectors.joining(", "))));
    }

    private void oneToManyDefaultConstructor() {
        ExampleUtil.log("oneToManyDefaultConstructor");
        Join join = ((JoinBuilder2)this.joinComponent.from(LanguageManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.LANGUAGE_ID).equal((HasComparableOperators)Language.LANGUAGE_ID)).build();
        join.stream().forEach(System.out::println);
    }

    private void oneToManyCustomConstructor() {
        ExampleUtil.log("oneToManyCustomConstructor");
        Join join = ((JoinBuilder2)this.joinComponent.from(LanguageManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.LANGUAGE_ID).equal((HasComparableOperators)Language.LANGUAGE_ID)).build((x$0, x$1) -> new TitleLanguageName((Language)x$0, (Film)x$1));
        join.stream().forEach(System.out::println);
    }

    private void oneToMany() {
        ExampleUtil.log("oneToMany");
        Join join = ((JoinBuilder2)this.joinComponent.from(LanguageManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.LANGUAGE_ID).equal((HasComparableOperators)Language.LANGUAGE_ID)).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void manyToOne() {
        ExampleUtil.log("manyToOne");
        Join join = ((JoinBuilder2)((JoinBuilder1)this.joinComponent.from(FilmManager.IDENTIFIER).where((Predicate)Film.RATING.equal((Comparable)((Object)"PG-13")))).innerJoinOn((HasComparableOperators)Language.LANGUAGE_ID).equal((HasComparableOperators)Film.LANGUAGE_ID)).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void manyToMany() {
        ExampleUtil.log("manyToMany");
        Join join = ((JoinBuilder3)((JoinBuilder2)this.joinComponent.from(FilmActorManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.FILM_ID).equal((HasComparableOperators)FilmActor.FILM_ID)).innerJoinOn((HasComparableOperators)Actor.ACTOR_ID).equal((HasComparableOperators)FilmActor.ACTOR_ID)).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void manyToManySkipLinkTable() {
        ExampleUtil.log("manyToManySkipLinkTable");
        Join join = ((JoinBuilder3)((JoinBuilder2)this.joinComponent.from(FilmActorManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Film.FILM_ID).equal((HasComparableOperators)FilmActor.FILM_ID)).innerJoinOn((HasComparableOperators)Actor.ACTOR_ID).equal((HasComparableOperators)FilmActor.ACTOR_ID)).build((fa, f, a) -> Tuples.of((Object)f, (Object)a));
        join.stream().forEach(System.out::println);
    }

    private void join() {
        ExampleUtil.log("join");
        Join join = ((JoinBuilder2)this.joinComponent.from(FilmManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Language.LANGUAGE_ID).equal((HasComparableOperators)Film.LANGUAGE_ID)).build(Tuples::of);
        join.stream().map(t2 -> String.format("The film '%s' is in %s", ((Film)t2.get0()).getTitle(), ((Language)t2.get1()).getName())).forEach(System.out::println);
    }

    private void selfJoin() {
        ExampleUtil.log("selfJoin");
        Join join = ((JoinBuilder2)this.joinComponent.from(ActorManager.IDENTIFIER).innerJoinOn((HasComparableOperators)Actor.FIRST_NAME.tableAlias("B")).equal((HasComparableOperators)Actor.FIRST_NAME)).build(Tuples::of);
        join.stream().forEach(System.out::println);
    }

    private void linked() {
        ExampleUtil.log("linked");
        Optional anyFilmInEnglish = this.languages.stream().filter(Language.NAME.equal((Comparable)((Object)"english"))).flatMap(this.films.finderBackwardsBy((HasFinder)Film.LANGUAGE_ID)).findAny();
        Optional languageOfFilmWithId42 = this.films.stream().filter(Film.FILM_ID.equal((Comparable)Integer.valueOf(42))).map(this.languages.finderBy((HasFinder)Film.LANGUAGE_ID)).findAny();
    }

    private void joinInMapOld() {
        ExampleUtil.log("joinInMap");
        Map languageFilmMap = this.films.stream().collect(Collectors.groupingBy(this.languages.finderBy((HasFinder)Film.LANGUAGE_ID)));
        languageFilmMap.forEach((l, fl) -> System.out.format("%s: %s%n", l.getName(), fl.stream().map(GeneratedFilm::getTitle).collect(Collectors.joining(", "))));
    }

    private final class TitleLanguageName {
        private final String title;
        private final String languageName;

        private TitleLanguageName(Language language, Film film) {
            this.title = film.getTitle();
            this.languageName = language.getName();
        }

        public String title() {
            return this.title;
        }

        public String languageName() {
            return this.languageName;
        }

        public String toString() {
            return "TitleLanguageName{title=" + this.title + ", languageName=" + this.languageName + '}';
        }
    }
}

