/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.example.basic_example;

import com.company.sakila.SakilaApplication;
import com.company.sakila.SakilaApplicationBuilder;
import com.company.sakila.db0.sakila.actor.ActorManager;
import com.company.sakila.db0.sakila.film.Film;
import com.company.sakila.db0.sakila.film.FilmManager;
import com.company.sakila.db0.sakila.language.Language;
import com.company.sakila.db0.sakila.language.LanguageImpl;
import com.company.sakila.db0.sakila.language.LanguageManager;
import com.speedment.example.basic_example.util.ExampleUtil;
import com.speedment.runtime.core.ApplicationBuilder;
import com.speedment.runtime.core.component.transaction.Isolation;
import com.speedment.runtime.core.component.transaction.TransactionComponent;
import com.speedment.runtime.core.component.transaction.TransactionHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Transaction {
    private final SakilaApplication app = ExampleUtil.buildApplication(b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLoggerName)ApplicationBuilder.LogType.PERSIST), b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLoggerName)ApplicationBuilder.LogType.UPDATE), b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLoggerName)ApplicationBuilder.LogType.REMOVE), b -> (SakilaApplicationBuilder)b.withLogging((ApplicationBuilder.HasLoggerName)ApplicationBuilder.LogType.TRANSACTION));
    private final FilmManager films = (FilmManager)this.app.getOrThrow(FilmManager.class);
    private final LanguageManager languages = (LanguageManager)this.app.getOrThrow(LanguageManager.class);
    private final ActorManager actors = (ActorManager)this.app.getOrThrow(ActorManager.class);
    private final TransactionComponent transactionComponent = (TransactionComponent)this.app.getOrThrow(TransactionComponent.class);
    private final TransactionHandler txHandler = this.transactionComponent.createTransactionHandler();

    public static void main(String[] args) {
        new Transaction().run();
    }

    private void run() {
        this.selectTransaction();
        this.selectTransaction2();
        this.createLanguagesUncommitted();
        this.deleteCommitted();
        this.isolationLevel();
    }

    private void selectTransaction() {
        ExampleUtil.log("selectTransaction");
        this.txHandler.createAndAccept(tx -> System.out.println(this.films.stream().filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(75))).count() + this.languages.stream().count()));
    }

    private void selectTransaction2() {
        ExampleUtil.log("selectTransaction2");
        long sumCount = (Long)this.txHandler.createAndApply(tx -> this.films.stream().filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(75))).count() + this.actors.stream().count());
        System.out.println(sumCount);
    }

    private void createLanguagesUncommitted() {
        ExampleUtil.log("createLanguagesUncommitted");
        long noLanguagesInTransaction = (Long)this.txHandler.createAndApply(tx -> {
            Stream.of(new LanguageImpl().setName("Italian"), new LanguageImpl().setName("German")).forEach((Consumer<Language>)this.languages.persister());
            return this.languages.stream().count();
        });
        long noLanguagesAfterTransaction = this.languages.stream().count();
        System.out.format("no languages in tx %d, no languages after transaction %d %n", noLanguagesInTransaction, noLanguagesAfterTransaction);
    }

    private void createLanguagesCommitted() {
        ExampleUtil.log("createLanguagesCommitted");
        long noLanguagesInTransaction = (Long)this.txHandler.createAndApply(tx -> {
            Stream.of(new LanguageImpl().setName("Italian"), new LanguageImpl().setName("German")).forEach((Consumer<Language>)this.languages.persister());
            tx.commit();
            return this.languages.stream().count();
        });
        long noLanguagesAfterTransaction = this.languages.stream().count();
        System.out.format("no languages in tx %d, no languages after transaction %d %n", noLanguagesInTransaction, noLanguagesAfterTransaction);
    }

    private void deleteCommitted() {
        ExampleUtil.log("deleteCommitted");
        this.txHandler.createAndAccept(tx -> {
            List toDelete = this.languages.stream().filter(Language.LANGUAGE_ID.notEqual((Comparable)Short.valueOf((short)1))).collect(Collectors.toList());
            toDelete.forEach(this.languages.remover());
            tx.commit();
        });
        long cnt = this.languages.stream().count();
        System.out.format("There are %d languages after delete %n", cnt);
    }

    private void isolationLevel() {
        ExampleUtil.log("isolationLevel");
        TransactionHandler txHandler = this.transactionComponent.createTransactionHandler();
        txHandler.setIsolation(Isolation.READ_COMMITTED);
        long sumCount = (Long)txHandler.createAndApply(tx -> this.films.stream().filter(Film.LENGTH.greaterThan((Comparable)Integer.valueOf(75))).count() + this.languages.stream().count());
        System.out.println(sumCount);
    }
}

