/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.spec;

import com.spotify.dataenum.processor.DataEnumProcessor;
import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.generator.match.MapMethods;
import com.spotify.dataenum.processor.generator.match.MatchMethods;
import com.spotify.dataenum.processor.generator.value.ValueMethods;
import com.spotify.dataenum.processor.generator.value.ValueTypeFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.spotify.dataenum.processor.util.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;

public final class SpecTypeFactory {
    private SpecTypeFactory() {
    }

    public static TypeSpec create(OutputSpec spec) throws ParserException {
        ArrayList<TypeSpec> valueTypes = new ArrayList<TypeSpec>();
        ArrayList<MethodSpec> factoryMethods = new ArrayList<MethodSpec>();
        ArrayList<MethodSpec> isMethods = new ArrayList<MethodSpec>();
        ArrayList<MethodSpec> asMethods = new ArrayList<MethodSpec>();
        MatchMethods matchMethods = new MatchMethods(spec.outputValues());
        MapMethods mapMethods = new MapMethods(spec.outputValues());
        for (OutputValue value : spec.outputValues()) {
            valueTypes.add(ValueTypeFactory.create(value, spec, matchMethods, mapMethods));
            ValueMethods valueMethods = new ValueMethods(value);
            factoryMethods.add(valueMethods.createFactoryMethod(spec));
            isMethods.add(valueMethods.createIsMethod());
            asMethods.add(valueMethods.createAsMethod());
        }
        TypeSpec.Builder enumBuilder = TypeSpec.classBuilder((ClassName)spec.outputClass()).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{DataEnumProcessor.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addTypeVariables(spec.typeVariables());
        enumBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        enumBuilder.addTypes(valueTypes);
        enumBuilder.addMethods(factoryMethods);
        enumBuilder.addMethods(isMethods);
        enumBuilder.addMethods(asMethods);
        if (!Iterables.isEmpty(spec.outputValues())) {
            enumBuilder.addMethod(matchMethods.createAbstractFoldVoidMethod());
            enumBuilder.addMethod(mapMethods.createAbstractFoldMethod());
        }
        return enumBuilder.build();
    }
}

