/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.match;

import com.spotify.dataenum.function.Consumer;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.generator.match.TypeVariableUtils;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;

public class MatchMethods {
    private final Iterable<OutputValue> values;

    public MatchMethods(Iterable<OutputValue> values) {
        this.values = values;
    }

    private MethodSpec.Builder createFoldVoidSignature(Iterable<TypeVariableName> availableTypeVariables) throws ParserException {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"match").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        for (OutputValue arg : this.values) {
            ParameterizedTypeName visitor = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{TypeVariableUtils.withoutMissingTypeVariables(arg.parameterizedOutputClass(), availableTypeVariables)});
            builder.addParameter(ParameterSpec.builder((TypeName)visitor, (String)MatchMethods.asCamelCase(arg.name()), (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build());
        }
        return builder;
    }

    public MethodSpec createAbstractFoldVoidMethod() throws ParserException {
        return this.createFoldVoidSignature(null).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build();
    }

    public MethodSpec createFoldVoidMethod(OutputValue value) throws ParserException {
        MethodSpec.Builder builder = this.createFoldVoidSignature(value.typeVariables()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.FINAL});
        builder.addStatement("$L.accept(this)", new Object[]{MatchMethods.asCamelCase(value.name())});
        return builder.build();
    }

    private static String asCamelCase(String text) {
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

