/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.parser;

import com.spotify.dataenum.dataenum_case;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.data.Value;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ValueParser {
    private ValueParser() {
    }

    static Value parse(Element element, ProcessingEnvironment processingEnv) {
        Messager messager = processingEnv.getMessager();
        if (element.getKind() != ElementKind.METHOD) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Value specs must be methods, found %s: %s", element.getKind().toString().toLowerCase(), element), element);
            return null;
        }
        ExecutableElement methodElement = (ExecutableElement)element;
        if (!ValueParser.isValueSpecMarker(methodElement.getReturnType(), processingEnv)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Value specs must return dataenum_case, found %s: %s", methodElement.getReturnType(), element), element);
            return null;
        }
        if (methodElement.getTypeParameters().size() != 0) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Type parameters must be specified on the top-level interface, found: %s", element), element);
            return null;
        }
        if (methodElement.isVarArgs()) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Vararg parameters not permitted: %s", element), element);
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (VariableElement variableElement : methodElement.getParameters()) {
            String parameterName = variableElement.getSimpleName().toString();
            TypeName parameterType = TypeName.get((TypeMirror)variableElement.asType());
            boolean nullable = false;
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                if (!ValueParser.isNullableAnnotation(annotationMirror)) continue;
                nullable = true;
                break;
            }
            parameters.add(new Parameter(parameterName, parameterType, nullable));
        }
        String valueSimpleName = methodElement.getSimpleName().toString();
        return new Value(valueSimpleName, parameters);
    }

    private static boolean isValueSpecMarker(TypeMirror returnType, ProcessingEnvironment processingEnvironment) {
        Types types = processingEnvironment.getTypeUtils();
        Elements elements = processingEnvironment.getElementUtils();
        return types.isSameType(returnType, elements.getTypeElement(dataenum_case.class.getCanonicalName()).asType());
    }

    private static boolean isNullableAnnotation(AnnotationMirror annotation) {
        Element annotationElement = annotation.getAnnotationType().asElement();
        return "Nullable".contentEquals(annotationElement.getSimpleName());
    }
}

