/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.spotify.github.GithubStyle;
import com.spotify.github.http.ImmutableLink;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableLink.class)
@JsonDeserialize(as=ImmutableLink.class)
@Value.Immutable
@GithubStyle
public interface Link {
    public URI url();

    public Optional<String> rel();

    public Optional<String> rev();

    public Optional<String> type();

    public Optional<String> media();

    public Optional<String> title();

    public Optional<String> anchor();

    public static Link from(String[] linkValues) {
        Map<String, String> linkResources = Arrays.stream(linkValues).map(value -> {
            Matcher linkValueMatcher = Pattern.compile("^<([^>]+)>$").matcher(value.trim());
            Matcher keyValueMatcher = Pattern.compile("(?<name>\\w+)=\"(?<value>[^\"]+)\"").matcher(value.trim());
            if (linkValueMatcher.find()) {
                return new AbstractMap.SimpleEntry<String, String>("url", linkValueMatcher.group(1));
            }
            if (keyValueMatcher.find()) {
                return new AbstractMap.SimpleEntry<String, String>(keyValueMatcher.group("name"), keyValueMatcher.group("value"));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableLink.Builder builder = ImmutableLink.builder().url(URI.create(linkResources.get("url"))).rel(linkResources.get("rel"));
        if (linkResources.containsKey("rev")) {
            builder.rev(linkResources.get("rev"));
        }
        if (linkResources.containsKey("type")) {
            builder.type(linkResources.get("type"));
        }
        if (linkResources.containsKey("media")) {
            builder.media(linkResources.get("media"));
        }
        if (linkResources.containsKey("title")) {
            builder.title(linkResources.get("title"));
        }
        if (linkResources.containsKey("anchor")) {
            builder.anchor(linkResources.get("anchor"));
        }
        return builder.build();
    }
}

