/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.github.GitHubInstant;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;

class GitHubInstantJsonDeserializer
extends JsonDeserializer<GitHubInstant> {
    static final GitHubInstantJsonDeserializer INSTANCE = new GitHubInstantJsonDeserializer();

    GitHubInstantJsonDeserializer() {
    }

    public GitHubInstant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (Optional.ofNullable(p.currentToken()).orElse(JsonToken.VALUE_NULL)) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_INT: {
                return GitHubInstant.create(p.getNumberValue());
            }
        }
        return GitHubInstant.create((Instant)p.readValueAs(Instant.class));
    }
}

